/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Endpoint
implements ToCopyableBuilder<Builder, Endpoint> {
    private final String address;
    private final Integer port;
    private final String hostedZoneId;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.port = builder.port;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String address() {
        return this.address;
    }

    public Integer port() {
        return this.port;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.address() == null ? 0 : this.address().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        if (other.address() != null && !other.address().equals(this.address())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        return other.hostedZoneId() == null || other.hostedZoneId().equals(this.hostedZoneId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String address;
        private Integer port;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.setAddress(model.address);
            this.setPort(model.port);
            this.setHostedZoneId(model.hostedZoneId);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Endpoint> {
        public Builder address(String var1);

        public Builder port(Integer var1);

        public Builder hostedZoneId(String var1);
    }
}

