/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetDBParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetDBParameterGroupRequest> {
    private final String dbParameterGroupName;
    private final Boolean resetAllParameters;
    private final List<Parameter> parameters;

    private ResetDBParameterGroupRequest(BuilderImpl builder) {
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameters = builder.parameters;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbParameterGroupName() == null ? 0 : this.dbParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.resetAllParameters() == null ? 0 : this.resetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDBParameterGroupRequest)) {
            return false;
        }
        ResetDBParameterGroupRequest other = (ResetDBParameterGroupRequest)((Object)obj);
        if (other.dbParameterGroupName() == null ^ this.dbParameterGroupName() == null) {
            return false;
        }
        if (other.dbParameterGroupName() != null && !other.dbParameterGroupName().equals(this.dbParameterGroupName())) {
            return false;
        }
        if (other.resetAllParameters() == null ^ this.resetAllParameters() == null) {
            return false;
        }
        if (other.resetAllParameters() != null && !other.resetAllParameters().equals(this.resetAllParameters())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.dbParameterGroupName()).append(",");
        }
        if (this.resetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.resetAllParameters()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupName;
        private Boolean resetAllParameters;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDBParameterGroupRequest model) {
            this.setDBParameterGroupName(model.dbParameterGroupName);
            this.setResetAllParameters(model.resetAllParameters);
            this.setParameters(model.parameters);
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
        }

        public ResetDBParameterGroupRequest build() {
            return new ResetDBParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetDBParameterGroupRequest> {
        public Builder dbParameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

