/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBClusterSnapshotAttributesResult
implements ToCopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
    private final String dbClusterSnapshotIdentifier;
    private final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private DBClusterSnapshotAttributesResult(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterSnapshotIdentifier() == null ? 0 : this.dbClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterSnapshotAttributes() == null ? 0 : this.dbClusterSnapshotAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttributesResult)) {
            return false;
        }
        DBClusterSnapshotAttributesResult other = (DBClusterSnapshotAttributesResult)obj;
        if (other.dbClusterSnapshotIdentifier() == null ^ this.dbClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() != null && !other.dbClusterSnapshotIdentifier().equals(this.dbClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.dbClusterSnapshotAttributes() == null ^ this.dbClusterSnapshotAttributes() == null) {
            return false;
        }
        return other.dbClusterSnapshotAttributes() == null || other.dbClusterSnapshotAttributes().equals(this.dbClusterSnapshotAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.dbClusterSnapshotAttributes() != null) {
            sb.append("DBClusterSnapshotAttributes: ").append(this.dbClusterSnapshotAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttributesResult model) {
            this.setDBClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.setDBClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final Collection<DBClusterSnapshotAttribute> getDBClusterSnapshotAttributes() {
            return this.dbClusterSnapshotAttributes;
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        public final void setDBClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
        }

        public DBClusterSnapshotAttributesResult build() {
            return new DBClusterSnapshotAttributesResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> var1);

        public Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... var1);
    }
}

