/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeOptionGroupOptionsRequest> {
    private final String engineName;
    private final String majorEngineVersion;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeOptionGroupOptionsRequest(BuilderImpl builder) {
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engineName() == null ? 0 : this.engineName().hashCode());
        hashCode = 31 * hashCode + (this.majorEngineVersion() == null ? 0 : this.majorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupOptionsRequest)) {
            return false;
        }
        DescribeOptionGroupOptionsRequest other = (DescribeOptionGroupOptionsRequest)((Object)obj);
        if (other.engineName() == null ^ this.engineName() == null) {
            return false;
        }
        if (other.engineName() != null && !other.engineName().equals(this.engineName())) {
            return false;
        }
        if (other.majorEngineVersion() == null ^ this.majorEngineVersion() == null) {
            return false;
        }
        if (other.majorEngineVersion() != null && !other.majorEngineVersion().equals(this.majorEngineVersion())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engineName() != null) {
            sb.append("EngineName: ").append(this.engineName()).append(",");
        }
        if (this.majorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.majorEngineVersion()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String engineName;
        private String majorEngineVersion;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupOptionsRequest model) {
            this.setEngineName(model.engineName);
            this.setMajorEngineVersion(model.majorEngineVersion);
            this.setFilters(model.filters);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOptionGroupOptionsRequest build() {
            return new DescribeOptionGroupOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOptionGroupOptionsRequest> {
        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

