/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupOptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
    private final List<OptionGroupOption> optionGroupOptions;
    private final String marker;

    private DescribeOptionGroupOptionsResponse(BuilderImpl builder) {
        this.optionGroupOptions = builder.optionGroupOptions;
        this.marker = builder.marker;
    }

    public List<OptionGroupOption> optionGroupOptions() {
        return this.optionGroupOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionGroupOptions() == null ? 0 : this.optionGroupOptions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupOptionsResponse)) {
            return false;
        }
        DescribeOptionGroupOptionsResponse other = (DescribeOptionGroupOptionsResponse)((Object)obj);
        if (other.optionGroupOptions() == null ^ this.optionGroupOptions() == null) {
            return false;
        }
        if (other.optionGroupOptions() != null && !other.optionGroupOptions().equals(this.optionGroupOptions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionGroupOptions() != null) {
            sb.append("OptionGroupOptions: ").append(this.optionGroupOptions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OptionGroupOption> optionGroupOptions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupOptionsResponse model) {
            this.setOptionGroupOptions(model.optionGroupOptions);
            this.setMarker(model.marker);
        }

        public final Collection<OptionGroupOption> getOptionGroupOptions() {
            return this.optionGroupOptions;
        }

        @Override
        public final Builder optionGroupOptions(Collection<OptionGroupOption> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copy(optionGroupOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(OptionGroupOption ... optionGroupOptions) {
            this.optionGroupOptions(Arrays.asList(optionGroupOptions));
            return this;
        }

        public final void setOptionGroupOptions(Collection<OptionGroupOption> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copy(optionGroupOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOptionGroupOptionsResponse build() {
            return new DescribeOptionGroupOptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
        public Builder optionGroupOptions(Collection<OptionGroupOption> var1);

        public Builder optionGroupOptions(OptionGroupOption ... var1);

        public Builder marker(String var1);
    }
}

