/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOrderableDBInstanceOptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeOrderableDBInstanceOptionsResponse> {
    private final List<OrderableDBInstanceOption> orderableDBInstanceOptions;
    private final String marker;

    private DescribeOrderableDBInstanceOptionsResponse(BuilderImpl builder) {
        this.orderableDBInstanceOptions = builder.orderableDBInstanceOptions;
        this.marker = builder.marker;
    }

    public List<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        return this.orderableDBInstanceOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.orderableDBInstanceOptions() == null ? 0 : this.orderableDBInstanceOptions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDBInstanceOptionsResponse)) {
            return false;
        }
        DescribeOrderableDBInstanceOptionsResponse other = (DescribeOrderableDBInstanceOptionsResponse)((Object)obj);
        if (other.orderableDBInstanceOptions() == null ^ this.orderableDBInstanceOptions() == null) {
            return false;
        }
        if (other.orderableDBInstanceOptions() != null && !other.orderableDBInstanceOptions().equals(this.orderableDBInstanceOptions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.orderableDBInstanceOptions() != null) {
            sb.append("OrderableDBInstanceOptions: ").append(this.orderableDBInstanceOptions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OrderableDBInstanceOption> orderableDBInstanceOptions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDBInstanceOptionsResponse model) {
            this.setOrderableDBInstanceOptions(model.orderableDBInstanceOptions);
            this.setMarker(model.marker);
        }

        public final Collection<OrderableDBInstanceOption> getOrderableDBInstanceOptions() {
            return this.orderableDBInstanceOptions;
        }

        @Override
        public final Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions(Arrays.asList(orderableDBInstanceOptions));
            return this;
        }

        public final void setOrderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOrderableDBInstanceOptionsResponse build() {
            return new DescribeOrderableDBInstanceOptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOrderableDBInstanceOptionsResponse> {
        public Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> var1);

        public Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... var1);

        public Builder marker(String var1);
    }
}

