/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDBParameterGroupRequest> {
    private final String dbParameterGroupName;
    private final String dbParameterGroupFamily;
    private final String description;
    private final List<Tag> tags;

    private CreateDBParameterGroupRequest(BuilderImpl builder) {
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String description() {
        return this.description;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbParameterGroupName() == null ? 0 : this.dbParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroupFamily() == null ? 0 : this.dbParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBParameterGroupRequest)) {
            return false;
        }
        CreateDBParameterGroupRequest other = (CreateDBParameterGroupRequest)((Object)obj);
        if (other.dbParameterGroupName() == null ^ this.dbParameterGroupName() == null) {
            return false;
        }
        if (other.dbParameterGroupName() != null && !other.dbParameterGroupName().equals(this.dbParameterGroupName())) {
            return false;
        }
        if (other.dbParameterGroupFamily() == null ^ this.dbParameterGroupFamily() == null) {
            return false;
        }
        if (other.dbParameterGroupFamily() != null && !other.dbParameterGroupFamily().equals(this.dbParameterGroupFamily())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.dbParameterGroupName()).append(",");
        }
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupName": {
                return Optional.of(clazz.cast(this.dbParameterGroupName()));
            }
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupName;
        private String dbParameterGroupFamily;
        private String description;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBParameterGroupRequest model) {
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CreateDBParameterGroupRequest build() {
            return new CreateDBParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDBParameterGroupRequest> {
        public Builder dbParameterGroupName(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

