/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.SupportedCharacterSetsListCopier;
import software.amazon.awssdk.services.rds.model.SupportedTimezonesListCopier;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBEngineVersion
implements ToCopyableBuilder<Builder, DBEngineVersion> {
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionDescription;
    private final CharacterSet defaultCharacterSet;
    private final List<CharacterSet> supportedCharacterSets;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<Timezone> supportedTimezones;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public CharacterSet defaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public List<CharacterSet> supportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public List<Timezone> supportedTimezones() {
        return this.supportedTimezones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroupFamily() == null ? 0 : this.dbParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.dbEngineDescription() == null ? 0 : this.dbEngineDescription().hashCode());
        hashCode = 31 * hashCode + (this.dbEngineVersionDescription() == null ? 0 : this.dbEngineVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.defaultCharacterSet() == null ? 0 : this.defaultCharacterSet().hashCode());
        hashCode = 31 * hashCode + (this.supportedCharacterSets() == null ? 0 : this.supportedCharacterSets().hashCode());
        hashCode = 31 * hashCode + (this.validUpgradeTarget() == null ? 0 : this.validUpgradeTarget().hashCode());
        hashCode = 31 * hashCode + (this.supportedTimezones() == null ? 0 : this.supportedTimezones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.dbParameterGroupFamily() == null ^ this.dbParameterGroupFamily() == null) {
            return false;
        }
        if (other.dbParameterGroupFamily() != null && !other.dbParameterGroupFamily().equals(this.dbParameterGroupFamily())) {
            return false;
        }
        if (other.dbEngineDescription() == null ^ this.dbEngineDescription() == null) {
            return false;
        }
        if (other.dbEngineDescription() != null && !other.dbEngineDescription().equals(this.dbEngineDescription())) {
            return false;
        }
        if (other.dbEngineVersionDescription() == null ^ this.dbEngineVersionDescription() == null) {
            return false;
        }
        if (other.dbEngineVersionDescription() != null && !other.dbEngineVersionDescription().equals(this.dbEngineVersionDescription())) {
            return false;
        }
        if (other.defaultCharacterSet() == null ^ this.defaultCharacterSet() == null) {
            return false;
        }
        if (other.defaultCharacterSet() != null && !other.defaultCharacterSet().equals(this.defaultCharacterSet())) {
            return false;
        }
        if (other.supportedCharacterSets() == null ^ this.supportedCharacterSets() == null) {
            return false;
        }
        if (other.supportedCharacterSets() != null && !other.supportedCharacterSets().equals(this.supportedCharacterSets())) {
            return false;
        }
        if (other.validUpgradeTarget() == null ^ this.validUpgradeTarget() == null) {
            return false;
        }
        if (other.validUpgradeTarget() != null && !other.validUpgradeTarget().equals(this.validUpgradeTarget())) {
            return false;
        }
        if (other.supportedTimezones() == null ^ this.supportedTimezones() == null) {
            return false;
        }
        return other.supportedTimezones() == null || other.supportedTimezones().equals(this.supportedTimezones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.dbEngineDescription() != null) {
            sb.append("DBEngineDescription: ").append(this.dbEngineDescription()).append(",");
        }
        if (this.dbEngineVersionDescription() != null) {
            sb.append("DBEngineVersionDescription: ").append(this.dbEngineVersionDescription()).append(",");
        }
        if (this.defaultCharacterSet() != null) {
            sb.append("DefaultCharacterSet: ").append(this.defaultCharacterSet()).append(",");
        }
        if (this.supportedCharacterSets() != null) {
            sb.append("SupportedCharacterSets: ").append(this.supportedCharacterSets()).append(",");
        }
        if (this.validUpgradeTarget() != null) {
            sb.append("ValidUpgradeTarget: ").append(this.validUpgradeTarget()).append(",");
        }
        if (this.supportedTimezones() != null) {
            sb.append("SupportedTimezones: ").append(this.supportedTimezones()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.of(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionDescription": {
                return Optional.of(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "DefaultCharacterSet": {
                return Optional.of(clazz.cast(this.defaultCharacterSet()));
            }
            case "SupportedCharacterSets": {
                return Optional.of(clazz.cast(this.supportedCharacterSets()));
            }
            case "ValidUpgradeTarget": {
                return Optional.of(clazz.cast(this.validUpgradeTarget()));
            }
            case "SupportedTimezones": {
                return Optional.of(clazz.cast(this.supportedTimezones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionDescription;
        private CharacterSet defaultCharacterSet;
        private List<CharacterSet> supportedCharacterSets;
        private List<UpgradeTarget> validUpgradeTarget;
        private List<Timezone> supportedTimezones;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.defaultCharacterSet(model.defaultCharacterSet);
            this.supportedCharacterSets(model.supportedCharacterSets);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.supportedTimezones(model.supportedTimezones);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDBEngineDescription() {
            return this.dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final void setDBEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        public final String getDBEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final void setDBEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return this.defaultCharacterSet != null ? this.defaultCharacterSet.toBuilder() : null;
        }

        @Override
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        public final Collection<CharacterSet.Builder> getSupportedCharacterSets() {
            return this.supportedCharacterSets != null ? (Collection)this.supportedCharacterSets.stream().map(CharacterSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet ... supportedCharacterSets) {
            this.supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        public final Collection<UpgradeTarget.Builder> getValidUpgradeTarget() {
            return this.validUpgradeTarget != null ? (Collection)this.validUpgradeTarget.stream().map(UpgradeTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        public final Collection<Timezone.Builder> getSupportedTimezones() {
            return this.supportedTimezones != null ? (Collection)this.supportedTimezones.stream().map(Timezone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Timezone ... supportedTimezones) {
            this.supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder defaultCharacterSet(CharacterSet var1);

        public Builder supportedCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedCharacterSets(CharacterSet ... var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder supportedTimezones(Collection<Timezone> var1);

        public Builder supportedTimezones(Timezone ... var1);
    }
}

