/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBLogFilesDetails
implements ToCopyableBuilder<Builder, DescribeDBLogFilesDetails> {
    private final String logFileName;
    private final Long lastWritten;
    private final Long size;

    private DescribeDBLogFilesDetails(BuilderImpl builder) {
        this.logFileName = builder.logFileName;
        this.lastWritten = builder.lastWritten;
        this.size = builder.size;
    }

    public String logFileName() {
        return this.logFileName;
    }

    public Long lastWritten() {
        return this.lastWritten;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logFileName() == null ? 0 : this.logFileName().hashCode());
        hashCode = 31 * hashCode + (this.lastWritten() == null ? 0 : this.lastWritten().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBLogFilesDetails)) {
            return false;
        }
        DescribeDBLogFilesDetails other = (DescribeDBLogFilesDetails)obj;
        if (other.logFileName() == null ^ this.logFileName() == null) {
            return false;
        }
        if (other.logFileName() != null && !other.logFileName().equals(this.logFileName())) {
            return false;
        }
        if (other.lastWritten() == null ^ this.lastWritten() == null) {
            return false;
        }
        if (other.lastWritten() != null && !other.lastWritten().equals(this.lastWritten())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.logFileName() != null) {
            sb.append("LogFileName: ").append(this.logFileName()).append(",");
        }
        if (this.lastWritten() != null) {
            sb.append("LastWritten: ").append(this.lastWritten()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogFileName": {
                return Optional.of(clazz.cast(this.logFileName()));
            }
            case "LastWritten": {
                return Optional.of(clazz.cast(this.lastWritten()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String logFileName;
        private Long lastWritten;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBLogFilesDetails model) {
            this.logFileName(model.logFileName);
            this.lastWritten(model.lastWritten);
            this.size(model.size);
        }

        public final String getLogFileName() {
            return this.logFileName;
        }

        @Override
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        public final Long getLastWritten() {
            return this.lastWritten;
        }

        @Override
        public final Builder lastWritten(Long lastWritten) {
            this.lastWritten = lastWritten;
            return this;
        }

        public final void setLastWritten(Long lastWritten) {
            this.lastWritten = lastWritten;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public DescribeDBLogFilesDetails build() {
            return new DescribeDBLogFilesDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBLogFilesDetails> {
        public Builder logFileName(String var1);

        public Builder lastWritten(Long var1);

        public Builder size(Long var1);
    }
}

