/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateDBClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CreateDBClusterParameterGroupRequest>, CreateDBClusterParameterGroupRequest> {
    public Request<CreateDBClusterParameterGroupRequest> marshall(CreateDBClusterParameterGroupRequest createDBClusterParameterGroupRequest) {
        List<Tag> tagsList;
        if (createDBClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBClusterParameterGroupRequest, "RDSClient");
        request.addParameter("Action", "CreateDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBClusterParameterGroupRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)createDBClusterParameterGroupRequest.dbClusterParameterGroupName()));
        }
        if (createDBClusterParameterGroupRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringUtils.fromString((String)createDBClusterParameterGroupRequest.dbParameterGroupFamily()));
        }
        if (createDBClusterParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createDBClusterParameterGroupRequest.description()));
        }
        if ((tagsList = createDBClusterParameterGroupRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

