/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateDBInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDBInstanceReadReplicaRequestMarshaller
implements Marshaller<Request<CreateDBInstanceReadReplicaRequest>, CreateDBInstanceReadReplicaRequest> {
    public Request<CreateDBInstanceReadReplicaRequest> marshall(CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) {
        List<Tag> tagsList;
        if (createDBInstanceReadReplicaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBInstanceReadReplicaRequest, "RDSClient");
        request.addParameter("Action", "CreateDBInstanceReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBInstanceReadReplicaRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.dbInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.sourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.sourceDBInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.dbInstanceClass()));
        }
        if (createDBInstanceReadReplicaRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.availabilityZone()));
        }
        if (createDBInstanceReadReplicaRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.port()));
        }
        if (createDBInstanceReadReplicaRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.autoMinorVersionUpgrade()));
        }
        if (createDBInstanceReadReplicaRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.iops()));
        }
        if (createDBInstanceReadReplicaRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.optionGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.publiclyAccessible()));
        }
        if ((tagsList = createDBInstanceReadReplicaRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createDBInstanceReadReplicaRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.dbSubnetGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.storageType()));
        }
        if (createDBInstanceReadReplicaRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.copyTagsToSnapshot()));
        }
        if (createDBInstanceReadReplicaRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)createDBInstanceReadReplicaRequest.monitoringInterval()));
        }
        if (createDBInstanceReadReplicaRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.monitoringRoleArn()));
        }
        if (createDBInstanceReadReplicaRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.kmsKeyId()));
        }
        if (createDBInstanceReadReplicaRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.preSignedUrl()));
        }
        if (createDBInstanceReadReplicaRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBInstanceReadReplicaRequest.enableIAMDatabaseAuthentication()));
        }
        if (createDBInstanceReadReplicaRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)createDBInstanceReadReplicaRequest.sourceRegion()));
        }
        return request;
    }
}

