/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.ModifyDBClusterSnapshotAttributeRequest;

public class ModifyDBClusterSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDBClusterSnapshotAttributeRequest>, ModifyDBClusterSnapshotAttributeRequest> {
    public Request<ModifyDBClusterSnapshotAttributeRequest> marshall(ModifyDBClusterSnapshotAttributeRequest modifyDBClusterSnapshotAttributeRequest) {
        List<String> valuesToRemoveList;
        List<String> valuesToAddList;
        if (modifyDBClusterSnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterSnapshotAttributeRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBClusterSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterSnapshotAttributeRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringUtils.fromString((String)modifyDBClusterSnapshotAttributeRequest.dbClusterSnapshotIdentifier()));
        }
        if (modifyDBClusterSnapshotAttributeRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString((String)modifyDBClusterSnapshotAttributeRequest.attributeName()));
        }
        if ((valuesToAddList = modifyDBClusterSnapshotAttributeRequest.valuesToAdd()) != null) {
            if (!valuesToAddList.isEmpty()) {
                int valuesToAddListIndex = 1;
                for (String valuesToAddListValue : valuesToAddList) {
                    if (valuesToAddListValue != null) {
                        request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringUtils.fromString((String)valuesToAddListValue));
                    }
                    ++valuesToAddListIndex;
                }
            } else {
                request.addParameter("ValuesToAdd", "");
            }
        }
        if ((valuesToRemoveList = modifyDBClusterSnapshotAttributeRequest.valuesToRemove()) != null) {
            if (!valuesToRemoveList.isEmpty()) {
                int valuesToRemoveListIndex = 1;
                for (String valuesToRemoveListValue : valuesToRemoveList) {
                    if (valuesToRemoveListValue != null) {
                        request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringUtils.fromString((String)valuesToRemoveListValue));
                    }
                    ++valuesToRemoveListIndex;
                }
            } else {
                request.addParameter("ValuesToRemove", "");
            }
        }
        return request;
    }
}

