/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;

public class UpgradeTargetUnmarshaller
implements Unmarshaller<UpgradeTarget, StaxUnmarshallerContext> {
    private static final UpgradeTargetUnmarshaller INSTANCE = new UpgradeTargetUnmarshaller();

    public UpgradeTarget unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        UpgradeTarget.Builder upgradeTarget = UpgradeTarget.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    upgradeTarget.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    upgradeTarget.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    upgradeTarget.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoUpgrade", targetDepth)) {
                    upgradeTarget.autoUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsMajorVersionUpgrade", targetDepth)) continue;
                upgradeTarget.isMajorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (UpgradeTarget)upgradeTarget.build();
    }

    public static UpgradeTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

