/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBEngineVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDBEngineVersionsRequest> {
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean defaultOnly;
    private final Boolean listSupportedCharacterSets;
    private final Boolean listSupportedTimezones;

    private DescribeDBEngineVersionsRequest(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
        this.listSupportedCharacterSets = builder.listSupportedCharacterSets;
        this.listSupportedTimezones = builder.listSupportedTimezones;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean defaultOnly() {
        return this.defaultOnly;
    }

    public Boolean listSupportedCharacterSets() {
        return this.listSupportedCharacterSets;
    }

    public Boolean listSupportedTimezones() {
        return this.listSupportedTimezones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.listSupportedCharacterSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.listSupportedTimezones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBEngineVersionsRequest)) {
            return false;
        }
        DescribeDBEngineVersionsRequest other = (DescribeDBEngineVersionsRequest)((Object)obj);
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.defaultOnly(), other.defaultOnly()) && Objects.equals(this.listSupportedCharacterSets(), other.listSupportedCharacterSets()) && Objects.equals(this.listSupportedTimezones(), other.listSupportedTimezones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.defaultOnly() != null) {
            sb.append("DefaultOnly: ").append(this.defaultOnly()).append(",");
        }
        if (this.listSupportedCharacterSets() != null) {
            sb.append("ListSupportedCharacterSets: ").append(this.listSupportedCharacterSets()).append(",");
        }
        if (this.listSupportedTimezones() != null) {
            sb.append("ListSupportedTimezones: ").append(this.listSupportedTimezones()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DefaultOnly": {
                return Optional.of(clazz.cast(this.defaultOnly()));
            }
            case "ListSupportedCharacterSets": {
                return Optional.of(clazz.cast(this.listSupportedCharacterSets()));
            }
            case "ListSupportedTimezones": {
                return Optional.of(clazz.cast(this.listSupportedTimezones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;
        private Boolean defaultOnly;
        private Boolean listSupportedCharacterSets;
        private Boolean listSupportedTimezones;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBEngineVersionsRequest model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.defaultOnly(model.defaultOnly);
            this.listSupportedCharacterSets(model.listSupportedCharacterSets);
            this.listSupportedTimezones(model.listSupportedTimezones);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        public final Boolean getListSupportedCharacterSets() {
            return this.listSupportedCharacterSets;
        }

        @Override
        public final Builder listSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
            return this;
        }

        public final void setListSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
        }

        public final Boolean getListSupportedTimezones() {
            return this.listSupportedTimezones;
        }

        @Override
        public final Builder listSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
            return this;
        }

        public final void setListSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
        }

        public DescribeDBEngineVersionsRequest build() {
            return new DescribeDBEngineVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBEngineVersionsRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder listSupportedCharacterSets(Boolean var1);

        public Builder listSupportedTimezones(Boolean var1);
    }
}

