/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.EventSubscription;
import software.amazon.awssdk.services.rds.model.EventSubscriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventSubscriptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
    private final String marker;
    private final List<EventSubscription> eventSubscriptionsList;

    private DescribeEventSubscriptionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.eventSubscriptionsList = builder.eventSubscriptionsList;
    }

    public String marker() {
        return this.marker;
    }

    public List<EventSubscription> eventSubscriptionsList() {
        return this.eventSubscriptionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSubscriptionsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsResponse)) {
            return false;
        }
        DescribeEventSubscriptionsResponse other = (DescribeEventSubscriptionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.eventSubscriptionsList(), other.eventSubscriptionsList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.eventSubscriptionsList() != null) {
            sb.append("EventSubscriptionsList: ").append(this.eventSubscriptionsList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "EventSubscriptionsList": {
                return Optional.of(clazz.cast(this.eventSubscriptionsList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<EventSubscription> eventSubscriptionsList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsResponse model) {
            this.marker(model.marker);
            this.eventSubscriptionsList(model.eventSubscriptionsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<EventSubscription.Builder> getEventSubscriptionsList() {
            return this.eventSubscriptionsList != null ? (Collection)this.eventSubscriptionsList.stream().map(EventSubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(EventSubscription ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
            return this;
        }

        public final void setEventSubscriptionsList(Collection<EventSubscription.BuilderImpl> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copyFromBuilder(eventSubscriptionsList);
        }

        public DescribeEventSubscriptionsResponse build() {
            return new DescribeEventSubscriptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
        public Builder marker(String var1);

        public Builder eventSubscriptionsList(Collection<EventSubscription> var1);

        public Builder eventSubscriptionsList(EventSubscription ... var1);
    }
}

