/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePendingMaintenanceActionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePendingMaintenanceActionsRequest> {
    private final String resourceIdentifier;
    private final List<Filter> filters;
    private final String marker;
    private final Integer maxRecords;

    private DescribePendingMaintenanceActionsRequest(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsRequest)) {
            return false;
        }
        DescribePendingMaintenanceActionsRequest other = (DescribePendingMaintenanceActionsRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.resourceIdentifier()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.of(clazz.cast(this.resourceIdentifier()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private List<Filter> filters;
        private String marker;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsRequest model) {
            this.resourceIdentifier(model.resourceIdentifier);
            this.filters(model.filters);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DescribePendingMaintenanceActionsRequest build() {
            return new DescribePendingMaintenanceActionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePendingMaintenanceActionsRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);
    }
}

