/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailoverDBClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, FailoverDBClusterRequest> {
    private final String dbClusterIdentifier;
    private final String targetDBInstanceIdentifier;

    private FailoverDBClusterRequest(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.targetDBInstanceIdentifier = builder.targetDBInstanceIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String targetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverDBClusterRequest)) {
            return false;
        }
        FailoverDBClusterRequest other = (FailoverDBClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.targetDBInstanceIdentifier(), other.targetDBInstanceIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.targetDBInstanceIdentifier() != null) {
            sb.append("TargetDBInstanceIdentifier: ").append(this.targetDBInstanceIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "TargetDBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.targetDBInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String targetDBInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverDBClusterRequest model) {
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.targetDBInstanceIdentifier(model.targetDBInstanceIdentifier);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getTargetDBInstanceIdentifier() {
            return this.targetDBInstanceIdentifier;
        }

        @Override
        public final Builder targetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
            return this;
        }

        public final void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
        }

        public FailoverDBClusterRequest build() {
            return new FailoverDBClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailoverDBClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder targetDBInstanceIdentifier(String var1);
    }
}

