/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeDBClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDBClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterSnapshotsRequest>, DescribeDBClusterSnapshotsRequest> {
    public Request<DescribeDBClusterSnapshotsRequest> marshall(DescribeDBClusterSnapshotsRequest describeDBClusterSnapshotsRequest) {
        List<Filter> filtersList;
        if (describeDBClusterSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterSnapshotsRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBClusterSnapshots");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterSnapshotsRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.dbClusterIdentifier()));
        }
        if (describeDBClusterSnapshotsRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.dbClusterSnapshotIdentifier()));
        }
        if (describeDBClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.snapshotType()));
        }
        if ((filtersList = describeDBClusterSnapshotsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeDBClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterSnapshotsRequest.maxRecords()));
        }
        if (describeDBClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.marker()));
        }
        if (describeDBClusterSnapshotsRequest.includeShared() != null) {
            request.addParameter("IncludeShared", StringUtils.fromBoolean((Boolean)describeDBClusterSnapshotsRequest.includeShared()));
        }
        if (describeDBClusterSnapshotsRequest.includePublic() != null) {
            request.addParameter("IncludePublic", StringUtils.fromBoolean((Boolean)describeDBClusterSnapshotsRequest.includePublic()));
        }
        return request;
    }
}

