/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.IPRange;

public class IPRangeUnmarshaller
implements Unmarshaller<IPRange, StaxUnmarshallerContext> {
    private static final IPRangeUnmarshaller INSTANCE = new IPRangeUnmarshaller();

    public IPRange unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IPRange.Builder ipRange = IPRange.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    ipRange.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CIDRIP", targetDepth)) continue;
                ipRange.cidrip(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IPRange)ipRange.build();
    }

    public static IPRangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

