/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.ModifyDBClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Parameter;

public class ModifyDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyDBClusterParameterGroupRequest>, ModifyDBClusterParameterGroupRequest> {
    public Request<ModifyDBClusterParameterGroupRequest> marshall(ModifyDBClusterParameterGroupRequest modifyDBClusterParameterGroupRequest) {
        List<Parameter> parametersList;
        if (modifyDBClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterParameterGroupRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterParameterGroupRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)modifyDBClusterParameterGroupRequest.dbClusterParameterGroupName()));
        }
        if ((parametersList = modifyDBClusterParameterGroupRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue.parameterName() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString((String)parametersListValue.parameterName()));
                    }
                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.parameterValue()));
                    }
                    if (parametersListValue.description() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString((String)parametersListValue.description()));
                    }
                    if (parametersListValue.source() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString((String)parametersListValue.source()));
                    }
                    if (parametersListValue.applyType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString((String)parametersListValue.applyType()));
                    }
                    if (parametersListValue.dataType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString((String)parametersListValue.dataType()));
                    }
                    if (parametersListValue.allowedValues() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString((String)parametersListValue.allowedValues()));
                    }
                    if (parametersListValue.isModifiable() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)parametersListValue.isModifiable()));
                    }
                    if (parametersListValue.minimumEngineVersion() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString((String)parametersListValue.minimumEngineVersion()));
                    }
                    if (parametersListValue.applyMethodString() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyMethod", StringUtils.fromString((String)parametersListValue.applyMethodString()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        return request;
    }
}

