/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.ModifyDBInstanceRequest;

public class ModifyDBInstanceRequestMarshaller
implements Marshaller<Request<ModifyDBInstanceRequest>, ModifyDBInstanceRequest> {
    public Request<ModifyDBInstanceRequest> marshall(ModifyDBInstanceRequest modifyDBInstanceRequest) {
        List<String> vpcSecurityGroupIdsList;
        List<String> dBSecurityGroupsList;
        if (modifyDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.allocatedStorage()));
        }
        if (modifyDBInstanceRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)modifyDBInstanceRequest.dbInstanceClass()));
        }
        if (modifyDBInstanceRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.dbSubnetGroupName()));
        }
        if ((dBSecurityGroupsList = modifyDBInstanceRequest.dbSecurityGroups()) != null) {
            if (!dBSecurityGroupsList.isEmpty()) {
                int dBSecurityGroupsListIndex = 1;
                for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                    if (dBSecurityGroupsListValue != null) {
                        request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)dBSecurityGroupsListValue));
                    }
                    ++dBSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("DBSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = modifyDBInstanceRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (modifyDBInstanceRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.applyImmediately()));
        }
        if (modifyDBInstanceRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyDBInstanceRequest.masterUserPassword()));
        }
        if (modifyDBInstanceRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.dbParameterGroupName()));
        }
        if (modifyDBInstanceRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.backupRetentionPeriod()));
        }
        if (modifyDBInstanceRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)modifyDBInstanceRequest.preferredBackupWindow()));
        }
        if (modifyDBInstanceRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBInstanceRequest.preferredMaintenanceWindow()));
        }
        if (modifyDBInstanceRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.multiAZ()));
        }
        if (modifyDBInstanceRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBInstanceRequest.engineVersion()));
        }
        if (modifyDBInstanceRequest.allowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.allowMajorVersionUpgrade()));
        }
        if (modifyDBInstanceRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.autoMinorVersionUpgrade()));
        }
        if (modifyDBInstanceRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)modifyDBInstanceRequest.licenseModel()));
        }
        if (modifyDBInstanceRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.iops()));
        }
        if (modifyDBInstanceRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyDBInstanceRequest.optionGroupName()));
        }
        if (modifyDBInstanceRequest.newDBInstanceIdentifier() != null) {
            request.addParameter("NewDBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.newDBInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)modifyDBInstanceRequest.storageType()));
        }
        if (modifyDBInstanceRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)modifyDBInstanceRequest.tdeCredentialArn()));
        }
        if (modifyDBInstanceRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)modifyDBInstanceRequest.tdeCredentialPassword()));
        }
        if (modifyDBInstanceRequest.caCertificateIdentifier() != null) {
            request.addParameter("CACertificateIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.caCertificateIdentifier()));
        }
        if (modifyDBInstanceRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)modifyDBInstanceRequest.domain()));
        }
        if (modifyDBInstanceRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.copyTagsToSnapshot()));
        }
        if (modifyDBInstanceRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.monitoringInterval()));
        }
        if (modifyDBInstanceRequest.dbPortNumber() != null) {
            request.addParameter("DBPortNumber", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.dbPortNumber()));
        }
        if (modifyDBInstanceRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.publiclyAccessible()));
        }
        if (modifyDBInstanceRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)modifyDBInstanceRequest.monitoringRoleArn()));
        }
        if (modifyDBInstanceRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)modifyDBInstanceRequest.domainIAMRoleName()));
        }
        if (modifyDBInstanceRequest.promotionTier() != null) {
            request.addParameter("PromotionTier", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.promotionTier()));
        }
        if (modifyDBInstanceRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.enableIAMDatabaseAuthentication()));
        }
        if (modifyDBInstanceRequest.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.enablePerformanceInsights()));
        }
        if (modifyDBInstanceRequest.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)modifyDBInstanceRequest.performanceInsightsKMSKeyId()));
        }
        return request;
    }
}

