/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionSetting;

public class ModifyOptionGroupRequestMarshaller
implements Marshaller<Request<ModifyOptionGroupRequest>, ModifyOptionGroupRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<ModifyOptionGroupRequest> marshall(ModifyOptionGroupRequest modifyOptionGroupRequest) {
        List<String> optionsToRemoveList;
        List<OptionConfiguration> optionsToIncludeList;
        if (modifyOptionGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyOptionGroupRequest, "RDSClient");
        request.addParameter("Action", "ModifyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyOptionGroupRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyOptionGroupRequest.optionGroupName()));
        }
        if ((optionsToIncludeList = modifyOptionGroupRequest.optionsToInclude()) != null) {
            if (!optionsToIncludeList.isEmpty()) {
                int optionsToIncludeListIndex = 1;
                for (OptionConfiguration optionsToIncludeListValue : optionsToIncludeList) {
                    List<OptionSetting> optionSettingsList;
                    List<String> vpcSecurityGroupMembershipsList;
                    List<String> dBSecurityGroupMembershipsList;
                    if (optionsToIncludeListValue.optionName() != null) {
                        request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionName", StringUtils.fromString((String)optionsToIncludeListValue.optionName()));
                    }
                    if (optionsToIncludeListValue.port() != null) {
                        request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".Port", StringUtils.fromInteger((Integer)optionsToIncludeListValue.port()));
                    }
                    if (optionsToIncludeListValue.optionVersion() != null) {
                        request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionVersion", StringUtils.fromString((String)optionsToIncludeListValue.optionVersion()));
                    }
                    if ((dBSecurityGroupMembershipsList = optionsToIncludeListValue.dbSecurityGroupMemberships()) != null) {
                        if (!dBSecurityGroupMembershipsList.isEmpty()) {
                            int dBSecurityGroupMembershipsListIndex = 1;
                            for (Object dBSecurityGroupMembershipsListValue : dBSecurityGroupMembershipsList) {
                                if (dBSecurityGroupMembershipsListValue != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships.DBSecurityGroupName." + dBSecurityGroupMembershipsListIndex, StringUtils.fromString((String)dBSecurityGroupMembershipsListValue));
                                }
                                ++dBSecurityGroupMembershipsListIndex;
                            }
                        } else {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships", "");
                        }
                    }
                    if ((vpcSecurityGroupMembershipsList = optionsToIncludeListValue.vpcSecurityGroupMemberships()) != null) {
                        if (!vpcSecurityGroupMembershipsList.isEmpty()) {
                            Object dBSecurityGroupMembershipsListValue;
                            int vpcSecurityGroupMembershipsListIndex = 1;
                            dBSecurityGroupMembershipsListValue = vpcSecurityGroupMembershipsList.iterator();
                            while (dBSecurityGroupMembershipsListValue.hasNext()) {
                                String vpcSecurityGroupMembershipsListValue = (String)dBSecurityGroupMembershipsListValue.next();
                                if (vpcSecurityGroupMembershipsListValue != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".VpcSecurityGroupMemberships.VpcSecurityGroupId." + vpcSecurityGroupMembershipsListIndex, StringUtils.fromString((String)vpcSecurityGroupMembershipsListValue));
                                }
                                ++vpcSecurityGroupMembershipsListIndex;
                            }
                        } else {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".VpcSecurityGroupMemberships", "");
                        }
                    }
                    if ((optionSettingsList = optionsToIncludeListValue.optionSettings()) != null) {
                        if (!optionSettingsList.isEmpty()) {
                            int optionSettingsListIndex = 1;
                            for (OptionSetting optionSettingsListValue : optionSettingsList) {
                                if (optionSettingsListValue.name() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Name", StringUtils.fromString((String)optionSettingsListValue.name()));
                                }
                                if (optionSettingsListValue.value() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                                }
                                if (optionSettingsListValue.defaultValue() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DefaultValue", StringUtils.fromString((String)optionSettingsListValue.defaultValue()));
                                }
                                if (optionSettingsListValue.description() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Description", StringUtils.fromString((String)optionSettingsListValue.description()));
                                }
                                if (optionSettingsListValue.applyType() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".ApplyType", StringUtils.fromString((String)optionSettingsListValue.applyType()));
                                }
                                if (optionSettingsListValue.dataType() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DataType", StringUtils.fromString((String)optionSettingsListValue.dataType()));
                                }
                                if (optionSettingsListValue.allowedValues() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".AllowedValues", StringUtils.fromString((String)optionSettingsListValue.allowedValues()));
                                }
                                if (optionSettingsListValue.isModifiable() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)optionSettingsListValue.isModifiable()));
                                }
                                if (optionSettingsListValue.isCollection() != null) {
                                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsCollection", StringUtils.fromBoolean((Boolean)optionSettingsListValue.isCollection()));
                                }
                                ++optionSettingsListIndex;
                            }
                        } else {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings", "");
                        }
                    }
                    ++optionsToIncludeListIndex;
                }
            } else {
                request.addParameter("OptionsToInclude", "");
            }
        }
        if ((optionsToRemoveList = modifyOptionGroupRequest.optionsToRemove()) != null) {
            if (!optionsToRemoveList.isEmpty()) {
                int optionsToRemoveListIndex = 1;
                for (String optionsToRemoveListValue : optionsToRemoveList) {
                    if (optionsToRemoveListValue != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex, StringUtils.fromString((String)optionsToRemoveListValue));
                    }
                    ++optionsToRemoveListIndex;
                }
            } else {
                request.addParameter("OptionsToRemove", "");
            }
        }
        if (modifyOptionGroupRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyOptionGroupRequest.applyImmediately()));
        }
        return request;
    }
}

