/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RestoreDBClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDBClusterFromS3RequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromS3Request>, RestoreDBClusterFromS3Request> {
    /*
     * WARNING - void declaration
     */
    public Request<RestoreDBClusterFromS3Request> marshall(RestoreDBClusterFromS3Request restoreDBClusterFromS3Request) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        if (restoreDBClusterFromS3Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromS3Request, "RDSClient");
        request.addParameter("Action", "RestoreDBClusterFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> availabilityZonesList = restoreDBClusterFromS3Request.availabilityZones();
        if (availabilityZonesList != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String string : availabilityZonesList) {
                    if (string != null) {
                        request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if (restoreDBClusterFromS3Request.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)restoreDBClusterFromS3Request.backupRetentionPeriod()));
        }
        if (restoreDBClusterFromS3Request.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)restoreDBClusterFromS3Request.characterSetName()));
        }
        if (restoreDBClusterFromS3Request.databaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromS3Request.databaseName()));
        }
        if (restoreDBClusterFromS3Request.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromS3Request.dbClusterIdentifier()));
        }
        if (restoreDBClusterFromS3Request.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.dbClusterParameterGroupName()));
        }
        if ((vpcSecurityGroupIdsList = restoreDBClusterFromS3Request.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (restoreDBClusterFromS3Request.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.dbSubnetGroupName()));
        }
        if (restoreDBClusterFromS3Request.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromS3Request.engine()));
        }
        if (restoreDBClusterFromS3Request.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromS3Request.engineVersion()));
        }
        if (restoreDBClusterFromS3Request.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromS3Request.port()));
        }
        if (restoreDBClusterFromS3Request.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)restoreDBClusterFromS3Request.masterUsername()));
        }
        if (restoreDBClusterFromS3Request.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)restoreDBClusterFromS3Request.masterUserPassword()));
        }
        if (restoreDBClusterFromS3Request.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromS3Request.optionGroupName()));
        }
        if (restoreDBClusterFromS3Request.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)restoreDBClusterFromS3Request.preferredBackupWindow()));
        }
        if (restoreDBClusterFromS3Request.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreDBClusterFromS3Request.preferredMaintenanceWindow()));
        }
        if ((tagsList = restoreDBClusterFromS3Request.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (restoreDBClusterFromS3Request.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)restoreDBClusterFromS3Request.storageEncrypted()));
        }
        if (restoreDBClusterFromS3Request.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromS3Request.kmsKeyId()));
        }
        if (restoreDBClusterFromS3Request.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromS3Request.enableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterFromS3Request.sourceEngine() != null) {
            request.addParameter("SourceEngine", StringUtils.fromString((String)restoreDBClusterFromS3Request.sourceEngine()));
        }
        if (restoreDBClusterFromS3Request.sourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringUtils.fromString((String)restoreDBClusterFromS3Request.sourceEngineVersion()));
        }
        if (restoreDBClusterFromS3Request.s3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString((String)restoreDBClusterFromS3Request.s3BucketName()));
        }
        if (restoreDBClusterFromS3Request.s3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString((String)restoreDBClusterFromS3Request.s3Prefix()));
        }
        if (restoreDBClusterFromS3Request.s3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringUtils.fromString((String)restoreDBClusterFromS3Request.s3IngestionRoleArn()));
        }
        return request;
    }
}

