/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RestoreDBInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDBInstanceFromS3RequestMarshaller
implements Marshaller<Request<RestoreDBInstanceFromS3Request>, RestoreDBInstanceFromS3Request> {
    /*
     * WARNING - void declaration
     */
    public Request<RestoreDBInstanceFromS3Request> marshall(RestoreDBInstanceFromS3Request restoreDBInstanceFromS3Request) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        List<String> dBSecurityGroupsList;
        if (restoreDBInstanceFromS3Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBInstanceFromS3Request, "RDSClient");
        request.addParameter("Action", "RestoreDBInstanceFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBInstanceFromS3Request.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.dbName()));
        }
        if (restoreDBInstanceFromS3Request.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceFromS3Request.dbInstanceIdentifier()));
        }
        if (restoreDBInstanceFromS3Request.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.allocatedStorage()));
        }
        if (restoreDBInstanceFromS3Request.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)restoreDBInstanceFromS3Request.dbInstanceClass()));
        }
        if (restoreDBInstanceFromS3Request.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBInstanceFromS3Request.engine()));
        }
        if (restoreDBInstanceFromS3Request.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)restoreDBInstanceFromS3Request.masterUsername()));
        }
        if (restoreDBInstanceFromS3Request.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)restoreDBInstanceFromS3Request.masterUserPassword()));
        }
        if ((dBSecurityGroupsList = restoreDBInstanceFromS3Request.dbSecurityGroups()) != null) {
            if (!dBSecurityGroupsList.isEmpty()) {
                int dBSecurityGroupsListIndex = 1;
                for (String string : dBSecurityGroupsList) {
                    if (string != null) {
                        request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)string));
                    }
                    ++dBSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("DBSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = restoreDBInstanceFromS3Request.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (restoreDBInstanceFromS3Request.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreDBInstanceFromS3Request.availabilityZone()));
        }
        if (restoreDBInstanceFromS3Request.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.dbSubnetGroupName()));
        }
        if (restoreDBInstanceFromS3Request.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreDBInstanceFromS3Request.preferredMaintenanceWindow()));
        }
        if (restoreDBInstanceFromS3Request.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.dbParameterGroupName()));
        }
        if (restoreDBInstanceFromS3Request.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.backupRetentionPeriod()));
        }
        if (restoreDBInstanceFromS3Request.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)restoreDBInstanceFromS3Request.preferredBackupWindow()));
        }
        if (restoreDBInstanceFromS3Request.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.port()));
        }
        if (restoreDBInstanceFromS3Request.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.multiAZ()));
        }
        if (restoreDBInstanceFromS3Request.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBInstanceFromS3Request.engineVersion()));
        }
        if (restoreDBInstanceFromS3Request.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.autoMinorVersionUpgrade()));
        }
        if (restoreDBInstanceFromS3Request.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)restoreDBInstanceFromS3Request.licenseModel()));
        }
        if (restoreDBInstanceFromS3Request.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.iops()));
        }
        if (restoreDBInstanceFromS3Request.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.optionGroupName()));
        }
        if (restoreDBInstanceFromS3Request.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.publiclyAccessible()));
        }
        if ((tagsList = restoreDBInstanceFromS3Request.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (restoreDBInstanceFromS3Request.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBInstanceFromS3Request.storageType()));
        }
        if (restoreDBInstanceFromS3Request.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.storageEncrypted()));
        }
        if (restoreDBInstanceFromS3Request.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBInstanceFromS3Request.kmsKeyId()));
        }
        if (restoreDBInstanceFromS3Request.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.copyTagsToSnapshot()));
        }
        if (restoreDBInstanceFromS3Request.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.monitoringInterval()));
        }
        if (restoreDBInstanceFromS3Request.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)restoreDBInstanceFromS3Request.monitoringRoleArn()));
        }
        if (restoreDBInstanceFromS3Request.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.enableIAMDatabaseAuthentication()));
        }
        if (restoreDBInstanceFromS3Request.sourceEngine() != null) {
            request.addParameter("SourceEngine", StringUtils.fromString((String)restoreDBInstanceFromS3Request.sourceEngine()));
        }
        if (restoreDBInstanceFromS3Request.sourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringUtils.fromString((String)restoreDBInstanceFromS3Request.sourceEngineVersion()));
        }
        if (restoreDBInstanceFromS3Request.s3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.s3BucketName()));
        }
        if (restoreDBInstanceFromS3Request.s3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString((String)restoreDBInstanceFromS3Request.s3Prefix()));
        }
        if (restoreDBInstanceFromS3Request.s3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringUtils.fromString((String)restoreDBInstanceFromS3Request.s3IngestionRoleArn()));
        }
        if (restoreDBInstanceFromS3Request.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.enablePerformanceInsights()));
        }
        if (restoreDBInstanceFromS3Request.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)restoreDBInstanceFromS3Request.performanceInsightsKMSKeyId()));
        }
        return request;
    }
}

