/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroup;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.services.rds.model.IPRange;
import software.amazon.awssdk.services.rds.model.IPRangeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSecurityGroup
implements ToCopyableBuilder<Builder, DBSecurityGroup> {
    private final String ownerId;
    private final String dbSecurityGroupName;
    private final String dbSecurityGroupDescription;
    private final String vpcId;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final List<IPRange> ipRanges;
    private final String dbSecurityGroupArn;

    private DBSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.vpcId = builder.vpcId;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.dbSecurityGroupArn = builder.dbSecurityGroupArn;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public String dbSecurityGroupDescription() {
        return this.dbSecurityGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public List<IPRange> ipRanges() {
        return this.ipRanges;
    }

    public String dbSecurityGroupArn() {
        return this.dbSecurityGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroup)) {
            return false;
        }
        DBSecurityGroup other = (DBSecurityGroup)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(this.dbSecurityGroupDescription(), other.dbSecurityGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ec2SecurityGroups(), other.ec2SecurityGroups()) && Objects.equals(this.ipRanges(), other.ipRanges()) && Objects.equals(this.dbSecurityGroupArn(), other.dbSecurityGroupArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.dbSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: ").append(this.dbSecurityGroupName()).append(",");
        }
        if (this.dbSecurityGroupDescription() != null) {
            sb.append("DBSecurityGroupDescription: ").append(this.dbSecurityGroupDescription()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.ec2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: ").append(this.ec2SecurityGroups()).append(",");
        }
        if (this.ipRanges() != null) {
            sb.append("IPRanges: ").append(this.ipRanges()).append(",");
        }
        if (this.dbSecurityGroupArn() != null) {
            sb.append("DBSecurityGroupArn: ").append(this.dbSecurityGroupArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "DBSecurityGroupName": {
                return Optional.of(clazz.cast(this.dbSecurityGroupName()));
            }
            case "DBSecurityGroupDescription": {
                return Optional.of(clazz.cast(this.dbSecurityGroupDescription()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "EC2SecurityGroups": {
                return Optional.of(clazz.cast(this.ec2SecurityGroups()));
            }
            case "IPRanges": {
                return Optional.of(clazz.cast(this.ipRanges()));
            }
            case "DBSecurityGroupArn": {
                return Optional.of(clazz.cast(this.dbSecurityGroupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String dbSecurityGroupName;
        private String dbSecurityGroupDescription;
        private String vpcId;
        private List<EC2SecurityGroup> ec2SecurityGroups;
        private List<IPRange> ipRanges;
        private String dbSecurityGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSecurityGroup model) {
            this.ownerId(model.ownerId);
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.dbSecurityGroupDescription(model.dbSecurityGroupDescription);
            this.vpcId(model.vpcId);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
            this.ipRanges(model.ipRanges);
            this.dbSecurityGroupArn(model.dbSecurityGroupArn);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getDBSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDBSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getDBSecurityGroupDescription() {
            return this.dbSecurityGroupDescription;
        }

        @Override
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final void setDBSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<EC2SecurityGroup.Builder> getEC2SecurityGroups() {
            return this.ec2SecurityGroups != null ? (Collection)this.ec2SecurityGroups.stream().map(EC2SecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        public final void setEC2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public final Collection<IPRange.Builder> getIPRanges() {
            return this.ipRanges != null ? (Collection)this.ipRanges.stream().map(IPRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIPRanges(Collection<IPRange.BuilderImpl> ipRanges) {
            this.ipRanges = IPRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final String getDBSecurityGroupArn() {
            return this.dbSecurityGroupArn;
        }

        @Override
        public final Builder dbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
            return this;
        }

        public final void setDBSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
        }

        public DBSecurityGroup build() {
            return new DBSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSecurityGroup> {
        public Builder ownerId(String var1);

        public Builder dbSecurityGroupName(String var1);

        public Builder dbSecurityGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ipRanges(Collection<IPRange> var1);

        public Builder ipRanges(IPRange ... var1);

        public Builder dbSecurityGroupArn(String var1);
    }
}

