/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.OptionSettingConfigurationListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Option
implements ToCopyableBuilder<Builder, Option> {
    private final String optionName;
    private final String optionDescription;
    private final Boolean persistent;
    private final Boolean permanent;
    private final Integer port;
    private final String optionVersion;
    private final List<OptionSetting> optionSettings;
    private final List<DBSecurityGroupMembership> dbSecurityGroupMemberships;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

    private Option(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionDescription = builder.optionDescription;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.optionSettings = builder.optionSettings;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
    }

    public String optionName() {
        return this.optionName;
    }

    public String optionDescription() {
        return this.optionDescription;
    }

    public Boolean persistent() {
        return this.persistent;
    }

    public Boolean permanent() {
        return this.permanent;
    }

    public Integer port() {
        return this.port;
    }

    public String optionVersion() {
        return this.optionVersion;
    }

    public List<OptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<DBSecurityGroupMembership> dbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistent());
        hashCode = 31 * hashCode + Objects.hashCode(this.permanent());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupMemberships());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return Objects.equals(this.optionName(), other.optionName()) && Objects.equals(this.optionDescription(), other.optionDescription()) && Objects.equals(this.persistent(), other.persistent()) && Objects.equals(this.permanent(), other.permanent()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.optionVersion(), other.optionVersion()) && Objects.equals(this.optionSettings(), other.optionSettings()) && Objects.equals(this.dbSecurityGroupMemberships(), other.dbSecurityGroupMemberships()) && Objects.equals(this.vpcSecurityGroupMemberships(), other.vpcSecurityGroupMemberships());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.optionName() != null) {
            sb.append("OptionName: ").append(this.optionName()).append(",");
        }
        if (this.optionDescription() != null) {
            sb.append("OptionDescription: ").append(this.optionDescription()).append(",");
        }
        if (this.persistent() != null) {
            sb.append("Persistent: ").append(this.persistent()).append(",");
        }
        if (this.permanent() != null) {
            sb.append("Permanent: ").append(this.permanent()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.optionVersion() != null) {
            sb.append("OptionVersion: ").append(this.optionVersion()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (this.dbSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: ").append(this.dbSecurityGroupMemberships()).append(",");
        }
        if (this.vpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: ").append(this.vpcSecurityGroupMemberships()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionName": {
                return Optional.of(clazz.cast(this.optionName()));
            }
            case "OptionDescription": {
                return Optional.of(clazz.cast(this.optionDescription()));
            }
            case "Persistent": {
                return Optional.of(clazz.cast(this.persistent()));
            }
            case "Permanent": {
                return Optional.of(clazz.cast(this.permanent()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "OptionVersion": {
                return Optional.of(clazz.cast(this.optionVersion()));
            }
            case "OptionSettings": {
                return Optional.of(clazz.cast(this.optionSettings()));
            }
            case "DBSecurityGroupMemberships": {
                return Optional.of(clazz.cast(this.dbSecurityGroupMemberships()));
            }
            case "VpcSecurityGroupMemberships": {
                return Optional.of(clazz.cast(this.vpcSecurityGroupMemberships()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String optionName;
        private String optionDescription;
        private Boolean persistent;
        private Boolean permanent;
        private Integer port;
        private String optionVersion;
        private List<OptionSetting> optionSettings;
        private List<DBSecurityGroupMembership> dbSecurityGroupMemberships;
        private List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

        private BuilderImpl() {
        }

        private BuilderImpl(Option model) {
            this.optionName(model.optionName);
            this.optionDescription(model.optionDescription);
            this.persistent(model.persistent);
            this.permanent(model.permanent);
            this.port(model.port);
            this.optionVersion(model.optionVersion);
            this.optionSettings(model.optionSettings);
            this.dbSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            this.vpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final String getOptionDescription() {
            return this.optionDescription;
        }

        @Override
        public final Builder optionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
            return this;
        }

        public final void setOptionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return this.optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final Collection<OptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(OptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<DBSecurityGroupMembership.Builder> getDBSecurityGroupMemberships() {
            return this.dbSecurityGroupMemberships != null ? (Collection)this.dbSecurityGroupMemberships.stream().map(DBSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        public final void setDBSecurityGroupMemberships(Collection<DBSecurityGroupMembership.BuilderImpl> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copyFromBuilder(dbSecurityGroupMemberships);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroupMemberships() {
            return this.vpcSecurityGroupMemberships != null ? (Collection)this.vpcSecurityGroupMemberships.stream().map(VpcSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroupMemberships);
        }

        public Option build() {
            return new Option(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Option> {
        public Builder optionName(String var1);

        public Builder optionDescription(String var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder port(Integer var1);

        public Builder optionVersion(String var1);

        public Builder optionSettings(Collection<OptionSetting> var1);

        public Builder optionSettings(OptionSetting ... var1);

        public Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> var1);

        public Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... var1);
    }
}

