/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSnapshotAttribute
implements ToCopyableBuilder<Builder, DBSnapshotAttribute> {
    private final String attributeName;
    private final List<String> attributeValues;

    private DBSnapshotAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttribute)) {
            return false;
        }
        DBSnapshotAttribute other = (DBSnapshotAttribute)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValues(), other.attributeValues());
    }

    public String toString() {
        return ToString.builder((String)"DBSnapshotAttribute").add("AttributeName", (Object)this.attributeName()).add("AttributeValues", this.attributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "AttributeValues": {
                return Optional.of(clazz.cast(this.attributeValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<String> attributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttribute model) {
            this.attributeName(model.attributeName);
            this.attributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
        }

        public DBSnapshotAttribute build() {
            return new DBSnapshotAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSnapshotAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);
    }
}

