/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSnapshotAttributesResult
implements ToCopyableBuilder<Builder, DBSnapshotAttributesResult> {
    private final String dbSnapshotIdentifier;
    private final List<DBSnapshotAttribute> dbSnapshotAttributes;

    private DBSnapshotAttributesResult(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbSnapshotAttributes = builder.dbSnapshotAttributes;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public List<DBSnapshotAttribute> dbSnapshotAttributes() {
        return this.dbSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttributesResult)) {
            return false;
        }
        DBSnapshotAttributesResult other = (DBSnapshotAttributesResult)obj;
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbSnapshotAttributes(), other.dbSnapshotAttributes());
    }

    public String toString() {
        return ToString.builder((String)"DBSnapshotAttributesResult").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DBSnapshotAttributes", this.dbSnapshotAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBSnapshotAttributes": {
                return Optional.of(clazz.cast(this.dbSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private List<DBSnapshotAttribute> dbSnapshotAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttributesResult model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbSnapshotAttributes(model.dbSnapshotAttributes);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final Collection<DBSnapshotAttribute.Builder> getDBSnapshotAttributes() {
            return this.dbSnapshotAttributes != null ? (Collection)this.dbSnapshotAttributes.stream().map(DBSnapshotAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copy(dbSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(DBSnapshotAttribute ... dbSnapshotAttributes) {
            this.dbSnapshotAttributes(Arrays.asList(dbSnapshotAttributes));
            return this;
        }

        public final void setDBSnapshotAttributes(Collection<DBSnapshotAttribute.BuilderImpl> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copyFromBuilder(dbSnapshotAttributes);
        }

        public DBSnapshotAttributesResult build() {
            return new DBSnapshotAttributesResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSnapshotAttributesResult> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> var1);

        public Builder dbSnapshotAttributes(DBSnapshotAttribute ... var1);
    }
}

