/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.Subnet;
import software.amazon.awssdk.services.rds.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSubnetGroup
implements ToCopyableBuilder<Builder, DBSubnetGroup> {
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final String dbSubnetGroupArn;

    private DBSubnetGroup(BuilderImpl builder) {
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.dbSubnetGroupArn = builder.dbSubnetGroupArn;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public String dbSubnetGroupArn() {
        return this.dbSubnetGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSubnetGroup)) {
            return false;
        }
        DBSubnetGroup other = (DBSubnetGroup)obj;
        return Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.dbSubnetGroupDescription(), other.dbSubnetGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.dbSubnetGroupArn(), other.dbSubnetGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"DBSubnetGroup").add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DBSubnetGroupDescription", (Object)this.dbSubnetGroupDescription()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.subnets()).add("DBSubnetGroupArn", (Object)this.dbSubnetGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSubnetGroupName": {
                return Optional.of(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DBSubnetGroupDescription": {
                return Optional.of(clazz.cast(this.dbSubnetGroupDescription()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.of(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "DBSubnetGroupArn": {
                return Optional.of(clazz.cast(this.dbSubnetGroupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets;
        private String dbSubnetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSubnetGroup model) {
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.dbSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
            this.dbSubnetGroupArn(model.dbSubnetGroupArn);
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDBSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDBSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return this.subnets != null ? (Collection)this.subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        public final String getDBSubnetGroupArn() {
            return this.dbSubnetGroupArn;
        }

        @Override
        public final Builder dbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
            return this;
        }

        public final void setDBSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
        }

        public DBSubnetGroup build() {
            return new DBSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSubnetGroup> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder dbSubnetGroupArn(String var1);
    }
}

