/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsResponse;

public final class DescribeDBSnapshotsPaginator
implements SdkIterable<DescribeDBSnapshotsResponse> {
    private final RDSClient client;
    private final DescribeDBSnapshotsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBSnapshotsPaginator(RDSClient client, DescribeDBSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSnapshotsResponseFetcher();
    }

    public Iterator<DescribeDBSnapshotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBSnapshot> dbSnapshots() {
        Function<DescribeDBSnapshotsResponse, Iterator> getIterator = response -> response != null ? response.dbSnapshots().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBSnapshotsResponseFetcher
    implements NextPageFetcher<DescribeDBSnapshotsResponse> {
        private DescribeDBSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSnapshotsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSnapshotsResponse nextPage(DescribeDBSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotsPaginator.this.client.describeDBSnapshots(DescribeDBSnapshotsPaginator.this.firstRequest);
            }
            return DescribeDBSnapshotsPaginator.this.client.describeDBSnapshots((DescribeDBSnapshotsRequest)((Object)DescribeDBSnapshotsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

