/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsResponse;

public final class DescribeDBSubnetGroupsPaginator
implements SdkIterable<DescribeDBSubnetGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBSubnetGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBSubnetGroupsPaginator(RDSClient client, DescribeDBSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeDBSubnetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDBSubnetGroupsResponse, Iterator> getIterator = response -> response != null ? response.dbSubnetGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBSubnetGroupsResponseFetcher
    implements NextPageFetcher<DescribeDBSubnetGroupsResponse> {
        private DescribeDBSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSubnetGroupsResponse nextPage(DescribeDBSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsPaginator.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsPaginator.this.firstRequest);
            }
            return DescribeDBSubnetGroupsPaginator.this.client.describeDBSubnetGroups((DescribeDBSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

