/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionGroup;
import software.amazon.awssdk.services.rds.transform.OptionUnmarshaller;

public class OptionGroupUnmarshaller
implements Unmarshaller<OptionGroup, StaxUnmarshallerContext> {
    private static final OptionGroupUnmarshaller INSTANCE = new OptionGroupUnmarshaller();

    public OptionGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        OptionGroup.Builder optionGroup;
        block12: {
            optionGroup = OptionGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Option> options = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    optionGroup.options(options);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("OptionGroupName", targetDepth)) {
                        optionGroup.optionGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionGroupDescription", targetDepth)) {
                        optionGroup.optionGroupDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EngineName", targetDepth)) {
                        optionGroup.engineName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MajorEngineVersion", targetDepth)) {
                        optionGroup.majorEngineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Options", targetDepth)) {
                        options = new ArrayList<Option>();
                        continue;
                    }
                    if (context.testExpression("Options/Option", targetDepth)) {
                        options.add(OptionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AllowsVpcAndNonVpcInstanceMemberships", targetDepth)) {
                        optionGroup.allowsVpcAndNonVpcInstanceMemberships(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        optionGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("OptionGroupArn", targetDepth)) continue;
                    optionGroup.optionGroupArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            optionGroup.options(options);
        }
        return (OptionGroup)optionGroup.build();
    }

    public static OptionGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

