/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rds.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.rds.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements ToCopyableBuilder<Builder, Event> {
    private final String sourceIdentifier;
    private final String sourceType;
    private final String message;
    private final List<String> eventCategories;
    private final Instant date;
    private final String sourceArn;

    private Event(BuilderImpl builder) {
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.eventCategories = builder.eventCategories;
        this.date = builder.date;
        this.sourceArn = builder.sourceArn;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeString() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Instant date() {
        return this.date;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && Objects.equals(this.sourceTypeString(), other.sourceTypeString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.sourceArn(), other.sourceArn());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("SourceIdentifier", (Object)this.sourceIdentifier()).add("SourceType", (Object)this.sourceTypeString()).add("Message", (Object)this.message()).add("EventCategories", this.eventCategories()).add("Date", (Object)this.date()).add("SourceArn", (Object)this.sourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIdentifier": {
                return Optional.of(clazz.cast(this.sourceIdentifier()));
            }
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceTypeString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "EventCategories": {
                return Optional.of(clazz.cast(this.eventCategories()));
            }
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "SourceArn": {
                return Optional.of(clazz.cast(this.sourceArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIdentifier;
        private String sourceType;
        private String message;
        private List<String> eventCategories;
        private Instant date;
        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceType(model.sourceType);
            this.message(model.message);
            this.eventCategories(model.eventCategories);
            this.date(model.date);
            this.sourceArn(model.sourceArn);
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder sourceIdentifier(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder date(Instant var1);

        public Builder sourceArn(String var1);
    }
}

