/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionConfigurationListCopier;
import software.amazon.awssdk.services.rds.model.OptionNamesListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyOptionGroupRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, ModifyOptionGroupRequest> {
    private final String optionGroupName;
    private final List<OptionConfiguration> optionsToInclude;
    private final List<String> optionsToRemove;
    private final Boolean applyImmediately;

    private ModifyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.optionGroupName = builder.optionGroupName;
        this.optionsToInclude = builder.optionsToInclude;
        this.optionsToRemove = builder.optionsToRemove;
        this.applyImmediately = builder.applyImmediately;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<OptionConfiguration> optionsToInclude() {
        return this.optionsToInclude;
    }

    public List<String> optionsToRemove() {
        return this.optionsToRemove;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsToInclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyOptionGroupRequest)) {
            return false;
        }
        ModifyOptionGroupRequest other = (ModifyOptionGroupRequest)((Object)obj);
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.optionsToInclude(), other.optionsToInclude()) && Objects.equals(this.optionsToRemove(), other.optionsToRemove()) && Objects.equals(this.applyImmediately(), other.applyImmediately());
    }

    public String toString() {
        return ToString.builder((String)"ModifyOptionGroupRequest").add("OptionGroupName", (Object)this.optionGroupName()).add("OptionsToInclude", this.optionsToInclude()).add("OptionsToRemove", this.optionsToRemove()).add("ApplyImmediately", (Object)this.applyImmediately()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "OptionsToInclude": {
                return Optional.of(clazz.cast(this.optionsToInclude()));
            }
            case "OptionsToRemove": {
                return Optional.of(clazz.cast(this.optionsToRemove()));
            }
            case "ApplyImmediately": {
                return Optional.of(clazz.cast(this.applyImmediately()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String optionGroupName;
        private List<OptionConfiguration> optionsToInclude;
        private List<String> optionsToRemove;
        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyOptionGroupRequest model) {
            this.optionGroupName(model.optionGroupName);
            this.optionsToInclude(model.optionsToInclude);
            this.optionsToRemove(model.optionsToRemove);
            this.applyImmediately(model.applyImmediately);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<OptionConfiguration.Builder> getOptionsToInclude() {
            return this.optionsToInclude != null ? (Collection)this.optionsToInclude.stream().map(OptionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionsToInclude(Collection<OptionConfiguration> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copy(optionsToInclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToInclude(OptionConfiguration ... optionsToInclude) {
            this.optionsToInclude(Arrays.asList(optionsToInclude));
            return this;
        }

        public final void setOptionsToInclude(Collection<OptionConfiguration.BuilderImpl> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copyFromBuilder(optionsToInclude);
        }

        public final Collection<String> getOptionsToRemove() {
            return this.optionsToRemove;
        }

        @Override
        public final Builder optionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(String ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final void setOptionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyOptionGroupRequest build() {
            return new ModifyOptionGroupRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, ModifyOptionGroupRequest> {
        public Builder optionGroupName(String var1);

        public Builder optionsToInclude(Collection<OptionConfiguration> var1);

        public Builder optionsToInclude(OptionConfiguration ... var1);

        public Builder optionsToRemove(Collection<String> var1);

        public Builder optionsToRemove(String ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

