/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;

public class DescribeOptionGroupOptionsPublisher
implements SdkPublisher<DescribeOptionGroupOptionsResponse> {
    private final RDSAsyncClient client;
    private final DescribeOptionGroupOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOptionGroupOptionsPublisher(RDSAsyncClient client, DescribeOptionGroupOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOptionGroupOptionsPublisher(RDSAsyncClient client, DescribeOptionGroupOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOptionGroupOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOptionGroupOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<OptionGroupOption> optionGroupOptions() {
        Function<DescribeOptionGroupOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupOptions() != null) {
                return response.optionGroupOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeOptionGroupOptionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeOptionGroupOptionsPublisher resume(DescribeOptionGroupOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOptionGroupOptionsPublisher(this.client, (DescribeOptionGroupOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOptionGroupOptionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeOptionGroupOptionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeOptionGroupOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOptionGroupOptionsResponse> {
        private DescribeOptionGroupOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeOptionGroupOptionsResponse> nextPage(DescribeOptionGroupOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupOptionsPublisher.this.client.describeOptionGroupOptions(DescribeOptionGroupOptionsPublisher.this.firstRequest);
            }
            return DescribeOptionGroupOptionsPublisher.this.client.describeOptionGroupOptions((DescribeOptionGroupOptionsRequest)((Object)DescribeOptionGroupOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

