/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.ModifyDBSnapshotRequest;

public class ModifyDBSnapshotRequestMarshaller
implements Marshaller<Request<ModifyDBSnapshotRequest>, ModifyDBSnapshotRequest> {
    public Request<ModifyDBSnapshotRequest> marshall(ModifyDBSnapshotRequest modifyDBSnapshotRequest) {
        if (modifyDBSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDBSnapshotRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)modifyDBSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (modifyDBSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBSnapshotRequest.engineVersion()));
        }
        if (modifyDBSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyDBSnapshotRequest.optionGroupName()));
        }
        return request;
    }
}

