/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EngineFamily {
    MYSQL("MYSQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EngineFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EngineFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EngineFamily.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EngineFamily> knownValues() {
        return Stream.of(EngineFamily.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

