/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedDbInstancesRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeReservedDbInstancesRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::reservedDBInstanceId)).setter(DescribeReservedDbInstancesRequest.setter(Builder::reservedDBInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build()}).build();
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::reservedDBInstancesOfferingId)).setter(DescribeReservedDbInstancesRequest.setter(Builder::reservedDBInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::dbInstanceClass)).setter(DescribeReservedDbInstancesRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::duration)).setter(DescribeReservedDbInstancesRequest.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::productDescription)).setter(DescribeReservedDbInstancesRequest.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::offeringType)).setter(DescribeReservedDbInstancesRequest.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::multiAZ)).setter(DescribeReservedDbInstancesRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> LEASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::leaseId)).setter(DescribeReservedDbInstancesRequest.setter(Builder::leaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseId").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::filters)).setter(DescribeReservedDbInstancesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::maxRecords)).setter(DescribeReservedDbInstancesRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesRequest.getter(DescribeReservedDbInstancesRequest::marker)).setter(DescribeReservedDbInstancesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCE_ID_FIELD, RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, DURATION_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, LEASE_ID_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private final String reservedDBInstanceId;
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final String duration;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final String leaseId;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedDbInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.leaseId = builder.leaseId;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String duration() {
        return this.duration;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String leaseId() {
        return this.leaseId;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesRequest)) {
            return false;
        }
        DescribeReservedDbInstancesRequest other = (DescribeReservedDbInstancesRequest)((Object)obj);
        return Objects.equals(this.reservedDBInstanceId(), other.reservedDBInstanceId()) && Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.leaseId(), other.leaseId()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedDbInstancesRequest").add("ReservedDBInstanceId", (Object)this.reservedDBInstanceId()).add("ReservedDBInstancesOfferingId", (Object)this.reservedDBInstancesOfferingId()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Duration", (Object)this.duration()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("MultiAZ", (Object)this.multiAZ()).add("LeaseId", (Object)this.leaseId()).add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstanceId()));
            }
            case "ReservedDBInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "LeaseId": {
                return Optional.ofNullable(clazz.cast(this.leaseId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesRequest, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String reservedDBInstanceId;
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private String duration;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private String leaseId;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesRequest model) {
            super(model);
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.dbInstanceClass(model.dbInstanceClass);
            this.duration(model.duration);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.multiAZ(model.multiAZ);
            this.leaseId(model.leaseId);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getLeaseId() {
            return this.leaseId;
        }

        @Override
        public final Builder leaseId(String leaseId) {
            this.leaseId = leaseId;
            return this;
        }

        public final void setLeaseId(String leaseId) {
            this.leaseId = leaseId;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedDbInstancesRequest build() {
            return new DescribeReservedDbInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedDbInstancesRequest> {
        public Builder reservedDBInstanceId(String var1);

        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder duration(String var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder leaseId(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

