/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DBSnapshotListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbSnapshotsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbSnapshotsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbSnapshotsResponse.getter(DescribeDbSnapshotsResponse::marker)).setter(DescribeDbSnapshotsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBSnapshot>> DB_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSnapshots").getter(DescribeDbSnapshotsResponse.getter(DescribeDbSnapshotsResponse::dbSnapshots)).setter(DescribeDbSnapshotsResponse.setter(Builder::dbSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshots").build(), ListTrait.builder().memberLocationName("DBSnapshot").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshot").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_SNAPSHOTS_FIELD));
    private final String marker;
    private final List<DBSnapshot> dbSnapshots;

    private DescribeDbSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSnapshots = builder.dbSnapshots;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasDbSnapshots() {
        return this.dbSnapshots != null && !(this.dbSnapshots instanceof SdkAutoConstructList);
    }

    public List<DBSnapshot> dbSnapshots() {
        return this.dbSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSnapshotsResponse)) {
            return false;
        }
        DescribeDbSnapshotsResponse other = (DescribeDbSnapshotsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbSnapshots(), other.dbSnapshots());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbSnapshotsResponse").add("Marker", (Object)this.marker()).add("DBSnapshots", this.dbSnapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBSnapshots": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeDbSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSnapshot> dbSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSnapshotsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbSnapshots(model.dbSnapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSnapshot.Builder> getDbSnapshots() {
            return this.dbSnapshots != null ? (Collection)this.dbSnapshots.stream().map(DBSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSnapshots(Collection<DBSnapshot> dbSnapshots) {
            this.dbSnapshots = DBSnapshotListCopier.copy(dbSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshots(DBSnapshot ... dbSnapshots) {
            this.dbSnapshots(Arrays.asList(dbSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshots(Consumer<DBSnapshot.Builder> ... dbSnapshots) {
            this.dbSnapshots(Stream.of(dbSnapshots).map(c -> (DBSnapshot)((DBSnapshot.Builder)DBSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbSnapshots(Collection<DBSnapshot.BuilderImpl> dbSnapshots) {
            this.dbSnapshots = DBSnapshotListCopier.copyFromBuilder(dbSnapshots);
        }

        @Override
        public DescribeDbSnapshotsResponse build() {
            return new DescribeDbSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder dbSnapshots(Collection<DBSnapshot> var1);

        public Builder dbSnapshots(DBSnapshot ... var1);

        public Builder dbSnapshots(Consumer<DBSnapshot.Builder> ... var1);
    }
}

