/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionGroup> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(OptionGroup.getter(OptionGroup::optionGroupName)).setter(OptionGroup.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> OPTION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupDescription").getter(OptionGroup.getter(OptionGroup::optionGroupDescription)).setter(OptionGroup.setter(Builder::optionGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupDescription").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineName").getter(OptionGroup.getter(OptionGroup::engineName)).setter(OptionGroup.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(OptionGroup.getter(OptionGroup::majorEngineVersion)).setter(OptionGroup.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<List<Option>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(OptionGroup.getter(OptionGroup::options)).setter(OptionGroup.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName("Option").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Option").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowsVpcAndNonVpcInstanceMemberships").getter(OptionGroup.getter(OptionGroup::allowsVpcAndNonVpcInstanceMemberships)).setter(OptionGroup.setter(Builder::allowsVpcAndNonVpcInstanceMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowsVpcAndNonVpcInstanceMemberships").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(OptionGroup.getter(OptionGroup::vpcId)).setter(OptionGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> OPTION_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupArn").getter(OptionGroup.getter(OptionGroup::optionGroupArn)).setter(OptionGroup.setter(Builder::optionGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD, OPTION_GROUP_DESCRIPTION_FIELD, ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD, OPTIONS_FIELD, ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD, VPC_ID_FIELD, OPTION_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String optionGroupName;
    private final String optionGroupDescription;
    private final String engineName;
    private final String majorEngineVersion;
    private final List<Option> options;
    private final Boolean allowsVpcAndNonVpcInstanceMemberships;
    private final String vpcId;
    private final String optionGroupArn;

    private OptionGroup(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.optionGroupDescription = builder.optionGroupDescription;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.options = builder.options;
        this.allowsVpcAndNonVpcInstanceMemberships = builder.allowsVpcAndNonVpcInstanceMemberships;
        this.vpcId = builder.vpcId;
        this.optionGroupArn = builder.optionGroupArn;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String optionGroupDescription() {
        return this.optionGroupDescription;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public List<Option> options() {
        return this.options;
    }

    public Boolean allowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String optionGroupArn() {
        return this.optionGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsVpcAndNonVpcInstanceMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup)obj;
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.optionGroupDescription(), other.optionGroupDescription()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.allowsVpcAndNonVpcInstanceMemberships(), other.allowsVpcAndNonVpcInstanceMemberships()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.optionGroupArn(), other.optionGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"OptionGroup").add("OptionGroupName", (Object)this.optionGroupName()).add("OptionGroupDescription", (Object)this.optionGroupDescription()).add("EngineName", (Object)this.engineName()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("Options", this.options()).add("AllowsVpcAndNonVpcInstanceMemberships", (Object)this.allowsVpcAndNonVpcInstanceMemberships()).add("VpcId", (Object)this.vpcId()).add("OptionGroupArn", (Object)this.optionGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "OptionGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.optionGroupDescription()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "AllowsVpcAndNonVpcInstanceMemberships": {
                return Optional.ofNullable(clazz.cast(this.allowsVpcAndNonVpcInstanceMemberships()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OptionGroupArn": {
                return Optional.ofNullable(clazz.cast(this.optionGroupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroup, T> g) {
        return obj -> g.apply((OptionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optionGroupName;
        private String optionGroupDescription;
        private String engineName;
        private String majorEngineVersion;
        private List<Option> options = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowsVpcAndNonVpcInstanceMemberships;
        private String vpcId;
        private String optionGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroup model) {
            this.optionGroupName(model.optionGroupName);
            this.optionGroupDescription(model.optionGroupDescription);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
            this.options(model.options);
            this.allowsVpcAndNonVpcInstanceMemberships(model.allowsVpcAndNonVpcInstanceMemberships);
            this.vpcId(model.vpcId);
            this.optionGroupArn(model.optionGroupArn);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getOptionGroupDescription() {
            return this.optionGroupDescription;
        }

        @Override
        public final Builder optionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        public final void setOptionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final Collection<Option.Builder> getOptions() {
            return this.options != null ? (Collection)this.options.stream().map(Option::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder options(Collection<Option> options) {
            this.options = OptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Option ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<Option.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptions(Collection<Option.BuilderImpl> options) {
            this.options = OptionsListCopier.copyFromBuilder(options);
        }

        public final Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
            return this.allowsVpcAndNonVpcInstanceMemberships;
        }

        @Override
        public final Builder allowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
            return this;
        }

        public final void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOptionGroupArn() {
            return this.optionGroupArn;
        }

        @Override
        public final Builder optionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
            return this;
        }

        public final void setOptionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
        }

        public OptionGroup build() {
            return new OptionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionGroup> {
        public Builder optionGroupName(String var1);

        public Builder optionGroupDescription(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder options(Collection<Option> var1);

        public Builder options(Option ... var1);

        public Builder options(Consumer<Option.Builder> ... var1);

        public Builder allowsVpcAndNonVpcInstanceMemberships(Boolean var1);

        public Builder vpcId(String var1);

        public Builder optionGroupArn(String var1);
    }
}

