/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionsListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptionGroupOptionsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
    private static final SdkField<List<OptionGroupOption>> OPTION_GROUP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionGroupOptions").getter(DescribeOptionGroupOptionsResponse.getter(DescribeOptionGroupOptionsResponse::optionGroupOptions)).setter(DescribeOptionGroupOptionsResponse.setter(Builder::optionGroupOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptions").build(), ListTrait.builder().memberLocationName("OptionGroupOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionGroupOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeOptionGroupOptionsResponse.getter(DescribeOptionGroupOptionsResponse::marker)).setter(DescribeOptionGroupOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_OPTIONS_FIELD, MARKER_FIELD));
    private final List<OptionGroupOption> optionGroupOptions;
    private final String marker;

    private DescribeOptionGroupOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupOptions = builder.optionGroupOptions;
        this.marker = builder.marker;
    }

    public boolean hasOptionGroupOptions() {
        return this.optionGroupOptions != null && !(this.optionGroupOptions instanceof SdkAutoConstructList);
    }

    public List<OptionGroupOption> optionGroupOptions() {
        return this.optionGroupOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionGroupOptions() ? this.optionGroupOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupOptionsResponse)) {
            return false;
        }
        DescribeOptionGroupOptionsResponse other = (DescribeOptionGroupOptionsResponse)((Object)obj);
        return this.hasOptionGroupOptions() == other.hasOptionGroupOptions() && Objects.equals(this.optionGroupOptions(), other.optionGroupOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOptionGroupOptionsResponse").add("OptionGroupOptions", this.hasOptionGroupOptions() ? this.optionGroupOptions() : null).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupOptions": {
                return Optional.ofNullable(clazz.cast(this.optionGroupOptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptionGroupOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOptionGroupOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<OptionGroupOption> optionGroupOptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupOptionsResponse model) {
            super(model);
            this.optionGroupOptions(model.optionGroupOptions);
            this.marker(model.marker);
        }

        public final Collection<OptionGroupOption.Builder> getOptionGroupOptions() {
            if (this.optionGroupOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionGroupOptions != null ? (Collection)this.optionGroupOptions.stream().map(OptionGroupOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptions(Collection<OptionGroupOption> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copy(optionGroupOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(OptionGroupOption ... optionGroupOptions) {
            this.optionGroupOptions(Arrays.asList(optionGroupOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(Consumer<OptionGroupOption.Builder> ... optionGroupOptions) {
            this.optionGroupOptions(Stream.of(optionGroupOptions).map(c -> (OptionGroupOption)((OptionGroupOption.Builder)OptionGroupOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupOptions(Collection<OptionGroupOption.BuilderImpl> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copyFromBuilder(optionGroupOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOptionGroupOptionsResponse build() {
            return new DescribeOptionGroupOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
        public Builder optionGroupOptions(Collection<OptionGroupOption> var1);

        public Builder optionGroupOptions(OptionGroupOption ... var1);

        public Builder optionGroupOptions(Consumer<OptionGroupOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

