/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDbSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CopyDbSnapshotRequest> {
    private static final SdkField<String> SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBSnapshotIdentifier").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::sourceDBSnapshotIdentifier)).setter(CopyDbSnapshotRequest.setter(Builder::sourceDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBSnapshotIdentifier").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::targetDBSnapshotIdentifier)).setter(CopyDbSnapshotRequest.setter(Builder::targetDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::kmsKeyId)).setter(CopyDbSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::tags)).setter(CopyDbSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::copyTags)).setter(CopyDbSnapshotRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::preSignedUrl)).setter(CopyDbSnapshotRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::optionGroupName)).setter(CopyDbSnapshotRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(CopyDbSnapshotRequest.getter(CopyDbSnapshotRequest::sourceRegion)).setter(CopyDbSnapshotRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD, TARGET_DB_SNAPSHOT_IDENTIFIER_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, COPY_TAGS_FIELD, PRE_SIGNED_URL_FIELD, OPTION_GROUP_NAME_FIELD, SOURCE_REGION_FIELD));
    private final String sourceDBSnapshotIdentifier;
    private final String targetDBSnapshotIdentifier;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final Boolean copyTags;
    private final String preSignedUrl;
    private final String optionGroupName;
    private final String sourceRegion;

    private CopyDbSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBSnapshotIdentifier = builder.sourceDBSnapshotIdentifier;
        this.targetDBSnapshotIdentifier = builder.targetDBSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.copyTags = builder.copyTags;
        this.preSignedUrl = builder.preSignedUrl;
        this.optionGroupName = builder.optionGroupName;
        this.sourceRegion = builder.sourceRegion;
    }

    public String sourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public String targetDBSnapshotIdentifier() {
        return this.targetDBSnapshotIdentifier;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbSnapshotRequest)) {
            return false;
        }
        CopyDbSnapshotRequest other = (CopyDbSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceDBSnapshotIdentifier(), other.sourceDBSnapshotIdentifier()) && Objects.equals(this.targetDBSnapshotIdentifier(), other.targetDBSnapshotIdentifier()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public String toString() {
        return ToString.builder((String)"CopyDbSnapshotRequest").add("SourceDBSnapshotIdentifier", (Object)this.sourceDBSnapshotIdentifier()).add("TargetDBSnapshotIdentifier", (Object)this.targetDBSnapshotIdentifier()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("CopyTags", (Object)this.copyTags()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("OptionGroupName", (Object)this.optionGroupName()).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBSnapshotIdentifier()));
            }
            case "TargetDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBSnapshotIdentifier()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbSnapshotRequest, T> g) {
        return obj -> g.apply((CopyDbSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBSnapshotIdentifier;
        private String targetDBSnapshotIdentifier;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean copyTags;
        private String preSignedUrl;
        private String optionGroupName;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbSnapshotRequest model) {
            super(model);
            this.sourceDBSnapshotIdentifier(model.sourceDBSnapshotIdentifier);
            this.targetDBSnapshotIdentifier(model.targetDBSnapshotIdentifier);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.copyTags(model.copyTags);
            this.preSignedUrl(model.preSignedUrl);
            this.optionGroupName(model.optionGroupName);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceDBSnapshotIdentifier() {
            return this.sourceDBSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        }

        public final String getTargetDBSnapshotIdentifier() {
            return this.targetDBSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbSnapshotRequest build() {
            return new CopyDbSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyDbSnapshotRequest> {
        public Builder sourceDBSnapshotIdentifier(String var1);

        public Builder targetDBSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder copyTags(Boolean var1);

        public Builder preSignedUrl(String var1);

        public Builder optionGroupName(String var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

