/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.services.rds.model.FeatureNameListCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.SupportedCharacterSetsListCopier;
import software.amazon.awssdk.services.rds.model.SupportedTimezonesListCopier;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBEngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBEngineVersion.getter(DBEngineVersion::engine)).setter(DBEngineVersion.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::engineVersion)).setter(DBEngineVersion.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupFamily").getter(DBEngineVersion.getter(DBEngineVersion::dbParameterGroupFamily)).setter(DBEngineVersion.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineDescription)).setter(DBEngineVersion.setter(Builder::dbEngineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionDescription)).setter(DBEngineVersion.setter(Builder::dbEngineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build()}).build();
    private static final SdkField<CharacterSet> DEFAULT_CHARACTER_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultCharacterSet").getter(DBEngineVersion.getter(DBEngineVersion::defaultCharacterSet)).setter(DBEngineVersion.setter(Builder::defaultCharacterSet)).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCharacterSet").build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_NCHAR_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNcharCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedNcharCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedNcharCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNcharCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUpgradeTarget").getter(DBEngineVersion.getter(DBEngineVersion::validUpgradeTarget)).setter(DBEngineVersion.setter(Builder::validUpgradeTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(), ListTrait.builder().memberLocationName("UpgradeTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTarget").build()}).build()).build()}).build();
    private static final SdkField<List<Timezone>> SUPPORTED_TIMEZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTimezones").getter(DBEngineVersion.getter(DBEngineVersion::supportedTimezones)).setter(DBEngineVersion.setter(Builder::supportedTimezones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTimezones").build(), ListTrait.builder().memberLocationName("Timezone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Timezone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportableLogTypes").getter(DBEngineVersion.getter(DBEngineVersion::exportableLogTypes)).setter(DBEngineVersion.setter(Builder::exportableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLogExportsToCloudwatchLogs").getter(DBEngineVersion.getter(DBEngineVersion::supportsLogExportsToCloudwatchLogs)).setter(DBEngineVersion.setter(Builder::supportsLogExportsToCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_READ_REPLICA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsReadReplica").getter(DBEngineVersion.getter(DBEngineVersion::supportsReadReplica)).setter(DBEngineVersion.setter(Builder::supportsReadReplica)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsReadReplica").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineModes").getter(DBEngineVersion.getter(DBEngineVersion::supportedEngineModes)).setter(DBEngineVersion.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_FEATURE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFeatureNames").getter(DBEngineVersion.getter(DBEngineVersion::supportedFeatureNames)).setter(DBEngineVersion.setter(Builder::supportedFeatureNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFeatureNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBEngineVersion.getter(DBEngineVersion::status)).setter(DBEngineVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PARALLEL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsParallelQuery").getter(DBEngineVersion.getter(DBEngineVersion::supportsParallelQuery)).setter(DBEngineVersion.setter(Builder::supportsParallelQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsParallelQuery").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsGlobalDatabases").getter(DBEngineVersion.getter(DBEngineVersion::supportsGlobalDatabases)).setter(DBEngineVersion.setter(Builder::supportsGlobalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD, DB_ENGINE_VERSION_DESCRIPTION_FIELD, DEFAULT_CHARACTER_SET_FIELD, SUPPORTED_CHARACTER_SETS_FIELD, SUPPORTED_NCHAR_CHARACTER_SETS_FIELD, VALID_UPGRADE_TARGET_FIELD, SUPPORTED_TIMEZONES_FIELD, EXPORTABLE_LOG_TYPES_FIELD, SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD, SUPPORTS_READ_REPLICA_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTED_FEATURE_NAMES_FIELD, STATUS_FIELD, SUPPORTS_PARALLEL_QUERY_FIELD, SUPPORTS_GLOBAL_DATABASES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionDescription;
    private final CharacterSet defaultCharacterSet;
    private final List<CharacterSet> supportedCharacterSets;
    private final List<CharacterSet> supportedNcharCharacterSets;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<Timezone> supportedTimezones;
    private final List<String> exportableLogTypes;
    private final Boolean supportsLogExportsToCloudwatchLogs;
    private final Boolean supportsReadReplica;
    private final List<String> supportedEngineModes;
    private final List<String> supportedFeatureNames;
    private final String status;
    private final Boolean supportsParallelQuery;
    private final Boolean supportsGlobalDatabases;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.supportedNcharCharacterSets = builder.supportedNcharCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
        this.supportsReadReplica = builder.supportsReadReplica;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportedFeatureNames = builder.supportedFeatureNames;
        this.status = builder.status;
        this.supportsParallelQuery = builder.supportsParallelQuery;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public final String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public final String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public final CharacterSet defaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public final boolean hasSupportedCharacterSets() {
        return this.supportedCharacterSets != null && !(this.supportedCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public final boolean hasSupportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets != null && !(this.supportedNcharCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets;
    }

    public final boolean hasValidUpgradeTarget() {
        return this.validUpgradeTarget != null && !(this.validUpgradeTarget instanceof SdkAutoConstructList);
    }

    public final List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public final boolean hasSupportedTimezones() {
        return this.supportedTimezones != null && !(this.supportedTimezones instanceof SdkAutoConstructList);
    }

    public final List<Timezone> supportedTimezones() {
        return this.supportedTimezones;
    }

    public final boolean hasExportableLogTypes() {
        return this.exportableLogTypes != null && !(this.exportableLogTypes instanceof SdkAutoConstructList);
    }

    public final List<String> exportableLogTypes() {
        return this.exportableLogTypes;
    }

    public final Boolean supportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public final Boolean supportsReadReplica() {
        return this.supportsReadReplica;
    }

    public final boolean hasSupportedEngineModes() {
        return this.supportedEngineModes != null && !(this.supportedEngineModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public final boolean hasSupportedFeatureNames() {
        return this.supportedFeatureNames != null && !(this.supportedFeatureNames instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFeatureNames() {
        return this.supportedFeatureNames;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean supportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public final Boolean supportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCharacterSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTimezones() ? this.supportedTimezones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportableLogTypes() ? this.exportableLogTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLogExportsToCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsReadReplica());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineModes() ? this.supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsParallelQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsGlobalDatabases());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.dbEngineDescription(), other.dbEngineDescription()) && Objects.equals(this.dbEngineVersionDescription(), other.dbEngineVersionDescription()) && Objects.equals(this.defaultCharacterSet(), other.defaultCharacterSet()) && this.hasSupportedCharacterSets() == other.hasSupportedCharacterSets() && Objects.equals(this.supportedCharacterSets(), other.supportedCharacterSets()) && this.hasSupportedNcharCharacterSets() == other.hasSupportedNcharCharacterSets() && Objects.equals(this.supportedNcharCharacterSets(), other.supportedNcharCharacterSets()) && this.hasValidUpgradeTarget() == other.hasValidUpgradeTarget() && Objects.equals(this.validUpgradeTarget(), other.validUpgradeTarget()) && this.hasSupportedTimezones() == other.hasSupportedTimezones() && Objects.equals(this.supportedTimezones(), other.supportedTimezones()) && this.hasExportableLogTypes() == other.hasExportableLogTypes() && Objects.equals(this.exportableLogTypes(), other.exportableLogTypes()) && Objects.equals(this.supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs()) && Objects.equals(this.supportsReadReplica(), other.supportsReadReplica()) && this.hasSupportedEngineModes() == other.hasSupportedEngineModes() && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && this.hasSupportedFeatureNames() == other.hasSupportedFeatureNames() && Objects.equals(this.supportedFeatureNames(), other.supportedFeatureNames()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.supportsParallelQuery(), other.supportsParallelQuery()) && Objects.equals(this.supportsGlobalDatabases(), other.supportsGlobalDatabases());
    }

    public final String toString() {
        return ToString.builder((String)"DBEngineVersion").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("DBEngineDescription", (Object)this.dbEngineDescription()).add("DBEngineVersionDescription", (Object)this.dbEngineVersionDescription()).add("DefaultCharacterSet", (Object)this.defaultCharacterSet()).add("SupportedCharacterSets", this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null).add("SupportedNcharCharacterSets", this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null).add("ValidUpgradeTarget", this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null).add("SupportedTimezones", this.hasSupportedTimezones() ? this.supportedTimezones() : null).add("ExportableLogTypes", this.hasExportableLogTypes() ? this.exportableLogTypes() : null).add("SupportsLogExportsToCloudwatchLogs", (Object)this.supportsLogExportsToCloudwatchLogs()).add("SupportsReadReplica", (Object)this.supportsReadReplica()).add("SupportedEngineModes", this.hasSupportedEngineModes() ? this.supportedEngineModes() : null).add("SupportedFeatureNames", this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null).add("Status", (Object)this.status()).add("SupportsParallelQuery", (Object)this.supportsParallelQuery()).add("SupportsGlobalDatabases", (Object)this.supportsGlobalDatabases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "DefaultCharacterSet": {
                return Optional.ofNullable(clazz.cast(this.defaultCharacterSet()));
            }
            case "SupportedCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedCharacterSets()));
            }
            case "SupportedNcharCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedNcharCharacterSets()));
            }
            case "ValidUpgradeTarget": {
                return Optional.ofNullable(clazz.cast(this.validUpgradeTarget()));
            }
            case "SupportedTimezones": {
                return Optional.ofNullable(clazz.cast(this.supportedTimezones()));
            }
            case "ExportableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.exportableLogTypes()));
            }
            case "SupportsLogExportsToCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.supportsLogExportsToCloudwatchLogs()));
            }
            case "SupportsReadReplica": {
                return Optional.ofNullable(clazz.cast(this.supportsReadReplica()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportedFeatureNames": {
                return Optional.ofNullable(clazz.cast(this.supportedFeatureNames()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SupportsParallelQuery": {
                return Optional.ofNullable(clazz.cast(this.supportsParallelQuery()));
            }
            case "SupportsGlobalDatabases": {
                return Optional.ofNullable(clazz.cast(this.supportsGlobalDatabases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBEngineVersion, T> g) {
        return obj -> g.apply((DBEngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionDescription;
        private CharacterSet defaultCharacterSet;
        private List<CharacterSet> supportedCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<CharacterSet> supportedNcharCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();
        private List<Timezone> supportedTimezones = DefaultSdkAutoConstructList.getInstance();
        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsLogExportsToCloudwatchLogs;
        private Boolean supportsReadReplica;
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedFeatureNames = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Boolean supportsParallelQuery;
        private Boolean supportsGlobalDatabases;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.defaultCharacterSet(model.defaultCharacterSet);
            this.supportedCharacterSets(model.supportedCharacterSets);
            this.supportedNcharCharacterSets(model.supportedNcharCharacterSets);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.supportedTimezones(model.supportedTimezones);
            this.exportableLogTypes(model.exportableLogTypes);
            this.supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
            this.supportsReadReplica(model.supportsReadReplica);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportedFeatureNames(model.supportedFeatureNames);
            this.status(model.status);
            this.supportsParallelQuery(model.supportsParallelQuery);
            this.supportsGlobalDatabases(model.supportsGlobalDatabases);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDbEngineDescription() {
            return this.dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        public final String getDbEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return this.defaultCharacterSet != null ? this.defaultCharacterSet.toBuilder() : null;
        }

        @Override
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        public final Collection<CharacterSet.Builder> getSupportedCharacterSets() {
            if (this.supportedCharacterSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedCharacterSets != null ? (Collection)this.supportedCharacterSets.stream().map(CharacterSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet ... supportedCharacterSets) {
            this.supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... supportedCharacterSets) {
            this.supportedCharacterSets(Stream.of(supportedCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        public final Collection<CharacterSet.Builder> getSupportedNcharCharacterSets() {
            if (this.supportedNcharCharacterSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNcharCharacterSets != null ? (Collection)this.supportedNcharCharacterSets.stream().map(CharacterSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedNcharCharacterSets(Collection<CharacterSet> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copy(supportedNcharCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(CharacterSet ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Arrays.asList(supportedNcharCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Stream.of(supportedNcharCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedNcharCharacterSets(Collection<CharacterSet.BuilderImpl> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedNcharCharacterSets);
        }

        public final Collection<UpgradeTarget.Builder> getValidUpgradeTarget() {
            if (this.validUpgradeTarget instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validUpgradeTarget != null ? (Collection)this.validUpgradeTarget.stream().map(UpgradeTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... validUpgradeTarget) {
            this.validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> (UpgradeTarget)((UpgradeTarget.Builder)UpgradeTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        public final Collection<Timezone.Builder> getSupportedTimezones() {
            if (this.supportedTimezones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedTimezones != null ? (Collection)this.supportedTimezones.stream().map(Timezone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Timezone ... supportedTimezones) {
            this.supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Consumer<Timezone.Builder> ... supportedTimezones) {
            this.supportedTimezones(Stream.of(supportedTimezones).map(c -> (Timezone)((Timezone.Builder)Timezone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        public final Collection<String> getExportableLogTypes() {
            if (this.exportableLogTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportableLogTypes;
        }

        @Override
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportableLogTypes(String ... exportableLogTypes) {
            this.exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return this.supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        public final Boolean getSupportsReadReplica() {
            return this.supportsReadReplica;
        }

        @Override
        public final Builder supportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
            return this;
        }

        public final void setSupportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (this.supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineModes;
        }

        @Override
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        public final Collection<String> getSupportedFeatureNames() {
            if (this.supportedFeatureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFeatureNames;
        }

        @Override
        public final Builder supportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFeatureNames(String ... supportedFeatureNames) {
            this.supportedFeatureNames(Arrays.asList(supportedFeatureNames));
            return this;
        }

        public final void setSupportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getSupportsParallelQuery() {
            return this.supportsParallelQuery;
        }

        @Override
        public final Builder supportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
            return this;
        }

        public final void setSupportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return this.supportsGlobalDatabases;
        }

        @Override
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder defaultCharacterSet(CharacterSet var1);

        default public Builder defaultCharacterSet(Consumer<CharacterSet.Builder> defaultCharacterSet) {
            return this.defaultCharacterSet((CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation(defaultCharacterSet)).build());
        }

        public Builder supportedCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedCharacterSets(CharacterSet ... var1);

        public Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder supportedNcharCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedNcharCharacterSets(CharacterSet ... var1);

        public Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... var1);

        public Builder supportedTimezones(Collection<Timezone> var1);

        public Builder supportedTimezones(Timezone ... var1);

        public Builder supportedTimezones(Consumer<Timezone.Builder> ... var1);

        public Builder exportableLogTypes(Collection<String> var1);

        public Builder exportableLogTypes(String ... var1);

        public Builder supportsLogExportsToCloudwatchLogs(Boolean var1);

        public Builder supportsReadReplica(Boolean var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportedFeatureNames(Collection<String> var1);

        public Builder supportedFeatureNames(String ... var1);

        public Builder status(String var1);

        public Builder supportsParallelQuery(Boolean var1);

        public Builder supportsGlobalDatabases(Boolean var1);
    }
}

