/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyTarget;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbProxyTargetsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbProxyTargetsResponse> {
    private static final SdkField<List<DBProxyTarget>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(DescribeDbProxyTargetsResponse.getter(DescribeDbProxyTargetsResponse::targets)).setter(DescribeDbProxyTargetsResponse.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBProxyTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbProxyTargetsResponse.getter(DescribeDbProxyTargetsResponse::marker)).setter(DescribeDbProxyTargetsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD, MARKER_FIELD));
    private final List<DBProxyTarget> targets;
    private final String marker;

    private DescribeDbProxyTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.marker = builder.marker;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<DBProxyTarget> targets() {
        return this.targets;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxyTargetsResponse)) {
            return false;
        }
        DescribeDbProxyTargetsResponse other = (DescribeDbProxyTargetsResponse)((Object)obj);
        return this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbProxyTargetsResponse").add("Targets", this.hasTargets() ? this.targets() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxyTargetsResponse, T> g) {
        return obj -> g.apply((DescribeDbProxyTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBProxyTarget> targets = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxyTargetsResponse model) {
            super(model);
            this.targets(model.targets);
            this.marker(model.marker);
        }

        public final List<DBProxyTarget.Builder> getTargets() {
            List<DBProxyTarget.Builder> result = TargetListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Collection<DBProxyTarget> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(DBProxyTarget ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<DBProxyTarget.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (DBProxyTarget)((DBProxyTarget.Builder)DBProxyTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<DBProxyTarget.BuilderImpl> targets) {
            this.targets = TargetListCopier.copyFromBuilder(targets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDbProxyTargetsResponse build() {
            return new DescribeDbProxyTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbProxyTargetsResponse> {
        public Builder targets(Collection<DBProxyTarget> var1);

        public Builder targets(DBProxyTarget ... var1);

        public Builder targets(Consumer<DBProxyTarget.Builder> ... var1);

        public Builder marker(String var1);
    }
}

