/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbInstanceRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbInstanceRequest.Builder, CreateDbInstanceRequest> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(CreateDbInstanceRequest::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(CreateDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(CreateDbInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(CreateDbInstanceRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateDbInstanceRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(CreateDbInstanceRequest::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(CreateDbInstanceRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(CreateDbInstanceRequest::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateDbInstanceRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(CreateDbInstanceRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateDbInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(CreateDbInstanceRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(CreateDbInstanceRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(CreateDbInstanceRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateDbInstanceRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(CreateDbInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateDbInstanceRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateDbInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(CreateDbInstanceRequest::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(CreateDbInstanceRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(CreateDbInstanceRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(CreateDbInstanceRequest::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NcharCharacterSetName").getter(getter(CreateDbInstanceRequest::ncharCharacterSetName))
            .setter(setter(Builder::ncharCharacterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateDbInstanceRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(CreateDbInstanceRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateDbInstanceRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(CreateDbInstanceRequest::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialPassword").getter(getter(CreateDbInstanceRequest::tdeCredentialPassword))
            .setter(setter(Builder::tdeCredentialPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(CreateDbInstanceRequest::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateDbInstanceRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateDbInstanceRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(CreateDbInstanceRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(CreateDbInstanceRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(CreateDbInstanceRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(CreateDbInstanceRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(CreateDbInstanceRequest::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(CreateDbInstanceRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(CreateDbInstanceRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(CreateDbInstanceRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(CreateDbInstanceRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(CreateDbInstanceRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(CreateDbInstanceRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<ProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(CreateDbInstanceRequest::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<ProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessorFeature").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateDbInstanceRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(CreateDbInstanceRequest::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCustomerOwnedIp").getter(getter(CreateDbInstanceRequest::enableCustomerOwnedIp))
            .setter(setter(Builder::enableCustomerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD,
            DB_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, MASTER_USERNAME_FIELD,
            MASTER_USER_PASSWORD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, AVAILABILITY_ZONE_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PORT_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, CHARACTER_SET_NAME_FIELD,
            NCHAR_CHARACTER_SET_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD,
            STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, TDE_CREDENTIAL_PASSWORD_FIELD, STORAGE_ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, DOMAIN_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, PROMOTION_TIER_FIELD, TIMEZONE_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD,
            ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD,
            DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD));

    private final String dbName;

    private final String dbInstanceIdentifier;

    private final Integer allocatedStorage;

    private final String dbInstanceClass;

    private final String engine;

    private final String masterUsername;

    private final String masterUserPassword;

    private final List<String> dbSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String availabilityZone;

    private final String dbSubnetGroupName;

    private final String preferredMaintenanceWindow;

    private final String dbParameterGroupName;

    private final Integer backupRetentionPeriod;

    private final String preferredBackupWindow;

    private final Integer port;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String characterSetName;

    private final String ncharCharacterSetName;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private final String dbClusterIdentifier;

    private final String storageType;

    private final String tdeCredentialArn;

    private final String tdeCredentialPassword;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String domain;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final String domainIAMRoleName;

    private final Integer promotionTier;

    private final String timezone;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final List<String> enableCloudwatchLogsExports;

    private final List<ProcessorFeature> processorFeatures;

    private final Boolean deletionProtection;

    private final Integer maxAllocatedStorage;

    private final Boolean enableCustomerOwnedIp;

    private CreateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.timezone = builder.timezone;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
    }

    /**
     * <p>
     * The meaning of this parameter differs according to the database engine you use.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     * database is created in the DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     * database is created in the DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, a database
     * named <code>postgres</code> is created in the DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 63 letters, numbers, or underscores.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value
     * <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>
     * .
     * </p>
     * <p>
     * Default: <code>ORCL</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be longer than 8 characters
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>SQL Server</b>
     * </p>
     * <p>
     * Not applicable. Must be null.
     * </p>
     * <p>
     * <b>Amazon Aurora MySQL</b>
     * </p>
     * <p>
     * The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If
     * this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must contain 1 to 64 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * It can't be a word reserved by the database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Amazon Aurora PostgreSQL</b>
     * </p>
     * <p>
     * The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created.
     * If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is
     * created in the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must contain 1 to 63 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to
     * 9).
     * </p>
     * </li>
     * <li>
     * <p>
     * It can't be a word reserved by the database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The meaning of this parameter differs according to the database engine you use.</p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     *         database is created in the DB instance.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     *         database is created in the DB instance.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, a
     *         database named <code>postgres</code> is created in the DB instance.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 63 letters, numbers, or underscores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default
     *         value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for
     *         <code>DBName</code>.
     *         </p>
     *         <p>
     *         Default: <code>ORCL</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be longer than 8 characters
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>SQL Server</b>
     *         </p>
     *         <p>
     *         Not applicable. Must be null.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora MySQL</b>
     *         </p>
     *         <p>
     *         The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
     *         created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the
     *         DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must contain 1 to 64 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can't be a word reserved by the database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Amazon Aurora PostgreSQL</b>
     *         </p>
     *         <p>
     *         The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
     *         created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named
     *         <code>postgres</code> is created in the DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must contain 1 to 63 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or
     *         digits (0 to 9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can't be a word reserved by the database engine.
     *         </p>
     *         </li>
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The DB instance identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The DB instance identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The amount of storage (in gibibytes) to allocate for the DB instance.
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases,
     * though you are only charged for the space that you use in an Aurora cluster volume.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 10 to 3072.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>SQL Server</b>
     * </p>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 200 to 16384.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 20 to 16384.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 200 to 16384.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 100 to 16384.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 200 to 1024.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 20 to 1024.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The amount of storage (in gibibytes) to allocate for the DB instance.</p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database
     *         increases, though you are only charged for the space that you use in an Aurora cluster volume.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 10 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>SQL Server</b>
     *         </p>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 200 to 16384.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 20 to 16384.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 200 to 16384.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 100 to 16384.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 200 to 1024.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 20 to 1024.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance
     * classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes,
     * and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a>
     * in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
     *         instance classes are available in all AWS Regions, or for all database engines. For the full list of DB
     *         instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The name of the database engine to be used for this instance.
     * </p>
     * <p>
     * Not every database engine is available for every AWS Region.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mariadb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>postgres</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the database engine to be used for this instance. </p>
     *         <p>
     *         Not every database engine is available for every AWS Region.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mariadb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>postgres</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The name for the master user.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The name for the master user is managed by the DB cluster.
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required for MariaDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 16 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required for SQL Server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 128 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required for MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 16 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required for Oracle.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 30 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required for PostgreSQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be 1 to 63 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the master user.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The name for the master user is managed by the DB cluster.
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required for MariaDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required for SQL Server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 128 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required for MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required for Oracle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 30 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required for PostgreSQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be 1 to 63 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The password for the master user is managed by the DB cluster.
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 30 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * 
     * @return The password for the master user. The password can include any printable ASCII character except "/",
     *         """, or "@".</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The password for the master user is managed by the DB cluster.
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 30 characters.
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * Returns true if the DBSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB security groups to associate with this DB instance.
     * </p>
     * <p>
     * Default: The default DB security group for the database engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DB security groups to associate with this DB instance.</p>
     *         <p>
     *         Default: The default DB security group for the database engine.
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon EC2 VPC security groups to associate with this DB instance.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
     * </p>
     * <p>
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The Availability Zone (AZ) where the database will be created. For information on AWS Regions and Availability
     * Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
     * and Availability Zones</a>.
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.
     * </p>
     * <p>
     * Example: <code>us-east-1d</code>
     * </p>
     * <p>
     * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
     * deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.
     * </p>
     * <note>
     * <p>
     * If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom
     * Availability Zone to create the DB instance in.
     * </p>
     * <p>
     * For more information about RDS on VMware, see the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User
     * Guide.</a>
     * </p>
     * </note>
     * 
     * @return The Availability Zone (AZ) where the database will be created. For information on AWS Regions and
     *         Availability Zones, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Regions and Availability Zones</a>. </p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.
     *         </p>
     *         <p>
     *         Example: <code>us-east-1d</code>
     *         </p>
     *         <p>
     *         Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a
     *         Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current
     *         endpoint.
     *         </p>
     *         <note>
     *         <p>
     *         If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom
     *         Availability Zone to create the DB instance in.
     *         </p>
     *         <p>
     *         For more information about RDS on VMware, see the <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on
     *         VMware User Guide.</a>
     *         </p>
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A DB subnet group to associate with this DB instance.
     * </p>
     * <p>
     * If there is no DB subnet group, then it is a non-VPC DB instance.
     * </p>
     * 
     * @return A DB subnet group to associate with this DB instance.</p>
     *         <p>
     *         If there is no DB subnet group, then it is a non-VPC DB instance.
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     * >Amazon RDS Maintenance Window</a>.
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     *         >Amazon RDS Maintenance Window</a>. </p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the
     * default DB parameter group for the specified DB engine and version is used.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group to associate with this DB instance. If you do not specify a value,
     *         then the default DB parameter group for the specified DB engine and version is used.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. Setting this parameter to a positive number enables
     * backups. Setting this parameter to 0 disables automated backups.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 0 to 35
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be set to 0 if the DB instance is a source to read replicas
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained. Setting this parameter to a positive number
     *         enables backups. Setting this parameter to 0 disables automated backups.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The retention period for automated backups is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 0 to 35
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be set to 0 if the DB instance is a source to read replicas
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, using the
     * <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour
     * block of time for each AWS Region. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     * >Backup window</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, using
     *         the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random
     *         from an 8-hour block of time for each AWS Region. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     *         >Backup window</a> in the <i>Amazon RDS User Guide</i>. </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The port number on which the database accepts connections.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Default: <code>5432</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Default: <code>1521</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * <b>SQL Server</b>
     * </p>
     * <p>
     * Default: <code>1433</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
     * <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Default: <code>3306</code>
     * </p>
     * <p>
     * Valid values: <code>1150-65535</code>
     * </p>
     * <p>
     * Type: Integer
     * </p>
     * 
     * @return The port number on which the database accepts connections.</p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Default: <code>5432</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Type: Integer
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Default: <code>1521</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         <b>SQL Server</b>
     *         </p>
     *         <p>
     *         Default: <code>1433</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
     *         <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Default: <code>3306</code>
     *         </p>
     *         <p>
     *         Valid values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Type: Integer
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
     * </p>
     * 
     * @return A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * <p>
     * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
     * </p>
     * <p>
     * The following are the database engines and links to information about the major and minor versions that are
     * available with Amazon RDS. Not every database engine is available for every AWS Region.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB
     * cluster.
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
     * >MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * See <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
     * >Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on
     * Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle
     * Database Engine Release Notes</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * See <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS
     * for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The version number of the database engine to use.</p>
     *         <p>
     *         For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
     *         </p>
     *         <p>
     *         The following are the database engines and links to information about the major and minor versions that
     *         are available with Amazon RDS. Not every database engine is available for every AWS Region.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The version number of the database engine to be used by the DB instance is managed by the
     *         DB cluster.
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
     *         >MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
     *         >Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL
     *         on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         See <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html"
     *         >Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         See <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
     *         >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the
     * maintenance window. By default, minor engine upgrades are applied automatically.
     * </p>
     * 
     * @return A value that indicates whether minor engine upgrades are applied automatically to the DB instance during
     *         the maintenance window. By default, minor engine upgrades are applied automatically.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * License model information for this DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     * 
     * @return License model information for this DB instance.</p>
     *         <p>
     *         Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     *         <code>general-public-license</code>
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
     * instance. For information about valid Iops values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned
     * IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the
     * storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of the
     * storage amount for the DB instance.
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
     *         instance. For information about valid Iops values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
     *         Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>. </p>
     *         <p>
     *         Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and
     *         50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1
     *         and 50 of the storage amount for the DB instance.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * A value that indicates that the DB instance should be associated with the specified option group.
     * </p>
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
     * group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance
     * </p>
     * 
     * @return A value that indicates that the DB instance should be associated with the specified option group.</p>
     *         <p>
     *         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
     *         option group. Also, that option group can't be removed from a DB instance once it is associated with a DB
     *         instance
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * For supported engines, indicates that the DB instance should be associated with the specified CharacterSet.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The character set is managed by the DB cluster. For more information, see
     * <code>CreateDBCluster</code>.
     * </p>
     * 
     * @return For supported engines, indicates that the DB instance should be associated with the specified
     *         CharacterSet.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The character set is managed by the DB cluster. For more information, see
     *         <code>CreateDBCluster</code>.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The name of the NCHAR character set for the Oracle DB instance.
     * </p>
     * 
     * @return The name of the NCHAR character set for the Oracle DB instance.
     */
    public final String ncharCharacterSetName() {
        return ncharCharacterSetName;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is publicly accessible.
     * </p>
     * <p>
     * When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the
     * DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance
     * is ultimately controlled by the security group it uses, and that public access is not permitted if the security
     * group assigned to the DB instance doesn't permit it.
     * </p>
     * <p>
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that indicates whether the DB instance is publicly accessible.</p>
     *         <p>
     *         When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from
     *         within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access
     *         to the DB instance is ultimately controlled by the security group it uses, and that public access is not
     *         permitted if the security group assigned to the DB instance doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target region has an Internet gateway attached to it, the DB instance is
     *         public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is
     *         private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.
     *         </p>
     *         </li>
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to assign to the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags to assign to the DB instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier of the DB cluster that the instance will belong to.
     * </p>
     * 
     * @return The identifier of the DB cluster that the instance will belong to.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     * <p>
     * Valid values: <code>standard | gp2 | io1</code>
     * </p>
     * <p>
     * If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.
     * </p>
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
     * </p>
     * 
     * @return Specifies the storage type to be associated with the DB instance.</p>
     *         <p>
     *         Valid values: <code>standard | gp2 | io1</code>
     *         </p>
     *         <p>
     *         If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.
     *         </p>
     *         <p>
     *         Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * The password for the given ARN from the key store in order to access the device.
     * </p>
     * 
     * @return The password for the given ARN from the key store in order to access the device.
     */
    public final String tdeCredentialPassword() {
        return tdeCredentialPassword;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The encryption for DB instances is managed by the DB cluster.
     * </p>
     * 
     * @return A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The encryption for DB instances is managed by the DB cluster.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The AWS KMS key identifier for an encrypted DB instance.
     * </p>
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master key
     * (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. The AWS KMS key identifier is managed by the DB cluster. For more information, see
     * <code>CreateDBCluster</code>.
     * </p>
     * <p>
     * If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
     * parameter, then Amazon RDS uses your default CMK. There is a default CMK for your AWS account. Your AWS account
     * has a different default CMK for each AWS Region.
     * </p>
     * 
     * @return The AWS KMS key identifier for an encrypted DB instance.</p>
     *         <p>
     *         The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
     *         master key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. The AWS KMS key identifier is managed by the DB cluster. For more information, see
     *         <code>CreateDBCluster</code>.
     *         </p>
     *         <p>
     *         If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
     *         parameter, then Amazon RDS uses your default CMK. There is a default CMK for your AWS account. Your AWS
     *         account has a different default CMK for each AWS Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server,
     * Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     * Authentication</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
     *         Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     *         Authentication</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default,
     * tags are not copied.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB
     * instance has no effect on the DB cluster setting.
     * </p>
     * 
     * @return A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By
     *         default, tags are not copied.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora
     *         DB instance has no effect on the DB cluster setting.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To
     * disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value
     * other than 0.
     * </p>
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to
     *         a value other than 0.
     *         </p>
     *         <p>
     *         Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go
     * to <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * 
     * @return The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     *         For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     *         monitoring role, go to <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     *         >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     *         <code>MonitoringRoleArn</code> value.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * 
     * @return Specify the name of the IAM role to be used when making API calls to the Directory Service.
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure
     * of the existing primary instance. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
     * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Valid Values: 0 - 15
     * </p>
     * 
     * @return A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a
     *         failure of the existing primary instance. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
     *         > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Valid Values: 0 - 15
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The time zone of the DB instance. The time zone parameter is currently supported only by <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
     * >Microsoft SQL Server</a>.
     * </p>
     * 
     * @return The time zone of the DB instance. The time zone parameter is currently supported only by <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
     *         >Microsoft SQL Server</a>.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database
     * accounts. By default, mapping is disabled.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora. Mapping AWS IAM accounts to database accounts is managed by the DB
     * cluster.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
     *         database accounts. By default, mapping is disabled.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora. Mapping AWS IAM accounts to database accounts is managed by
     *         the DB cluster.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     *         Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
     * Insights</a> in the <i>Amazon Relational Database Service User Guide</i>.
     * </p>
     * 
     * @return A value that indicates whether to enable Performance Insights for the DB instance. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
     *         Performance Insights</a> in the <i>Amazon Relational Database Service User Guide</i>.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master key
     * (CMK).
     * </p>
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
     * CMK. There is a default CMK for your AWS account. Your AWS account has a different default CMK for each AWS
     * Region.
     * </p>
     * 
     * @return The AWS KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
     *         master key (CMK).
     *         </p>
     *         <p>
     *         If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default CMK. There is a default CMK for your AWS account. Your AWS account has a different default CMK
     *         for each AWS Region.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * </p>
     * 
     * @return The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * Returns true if the EnableCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on
     * the DB engine being used. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service User
     * Guide</i>.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
     * </p>
     * <p>
     * <b>MariaDB</b>
     * </p>
     * <p>
     * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * Possible values are <code>agent</code> and <code>error</code>.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and
     * <code>oemagent</code>.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Possible values are <code>postgresql</code> and <code>upgrade</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnableCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list
     *         depend on the DB engine being used. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service
     *         User Guide</i>.</p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. CloudWatch Logs exports are managed by the DB cluster.
     *         </p>
     *         <p>
     *         <b>MariaDB</b>
     *         </p>
     *         <p>
     *         Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
     *         <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         Possible values are <code>agent</code> and <code>error</code>.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
     *         <code>slowquery</code>.
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>,
     *         and <code>oemagent</code>.
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Possible values are <code>postgresql</code> and <code>upgrade</code>.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * Returns true if the ProcessorFeatures property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessorFeatures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public final List<ProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
     * when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     * Instance</a>.
     * </p>
     * <p>
     * <b>Amazon Aurora</b>
     * </p>
     * <p>
     * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see
     * <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is
     * enabled for the DB cluster.
     * </p>
     * 
     * @return A value that indicates whether the DB instance has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection is disabled. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     *         Instance</a>. </p>
     *         <p>
     *         <b>Amazon Aurora</b>
     *         </p>
     *         <p>
     *         Not applicable. You can enable or disable deletion protection for the DB cluster. For more information,
     *         see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion
     *         protection is enabled for the DB cluster.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p>
     *         <p>
     *         For more information about this setting, including limitations that apply to it, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
     *         > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
     *         Guide</i>.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     * </p>
     * <p>
     * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from
     * outside of its virtual private cloud (VPC) on your local network.
     * </p>
     * <p>
     * For more information about RDS on Outposts, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on AWS
     * Outposts</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about CoIPs, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
     * >Customer-owned IP addresses</a> in the <i>AWS Outposts User Guide</i>.
     * </p>
     * 
     * @return A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
     *         instance.</p>
     *         <p>
     *         A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     *         on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB
     *         instance from outside of its virtual private cloud (VPC) on your local network.
     *         </p>
     *         <p>
     *         For more information about RDS on Outposts, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
     *         RDS on AWS Outposts</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about CoIPs, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
     *         >Customer-owned IP addresses</a> in the <i>AWS Outposts User Guide</i>.
     */
    public final Boolean enableCustomerOwnedIp() {
        return enableCustomerOwnedIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(enableCustomerOwnedIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceRequest)) {
            return false;
        }
        CreateDbInstanceRequest other = (CreateDbInstanceRequest) obj;
        return Objects.equals(dbName(), other.dbName()) && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(engine(), other.engine())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(port(), other.port())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(ncharCharacterSetName(), other.ncharCharacterSetName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(tdeCredentialPassword(), other.tdeCredentialPassword())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(domain(), other.domain()) && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(promotionTier(), other.promotionTier()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(enableCustomerOwnedIp(), other.enableCustomerOwnedIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbInstanceRequest").add("DBName", dbName())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("AllocatedStorage", allocatedStorage())
                .add("DBInstanceClass", dbInstanceClass()).add("Engine", engine()).add("MasterUsername", masterUsername())
                .add("MasterUserPassword", masterUserPassword())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("AvailabilityZone", availabilityZone()).add("DBSubnetGroupName", dbSubnetGroupName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("DBParameterGroupName", dbParameterGroupName()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("PreferredBackupWindow", preferredBackupWindow()).add("Port", port()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("LicenseModel", licenseModel()).add("Iops", iops()).add("OptionGroupName", optionGroupName())
                .add("CharacterSetName", characterSetName()).add("NcharCharacterSetName", ncharCharacterSetName())
                .add("PubliclyAccessible", publiclyAccessible()).add("Tags", hasTags() ? tags() : null)
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("StorageType", storageType())
                .add("TdeCredentialArn", tdeCredentialArn()).add("TdeCredentialPassword", tdeCredentialPassword())
                .add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId()).add("Domain", domain())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("PromotionTier", promotionTier()).add("Timezone", timezone())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("DeletionProtection", deletionProtection()).add("MaxAllocatedStorage", maxAllocatedStorage())
                .add("EnableCustomerOwnedIp", enableCustomerOwnedIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "NcharCharacterSetName":
            return Optional.ofNullable(clazz.cast(ncharCharacterSetName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "TdeCredentialPassword":
            return Optional.ofNullable(clazz.cast(tdeCredentialPassword()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "EnableCustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(enableCustomerOwnedIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbInstanceRequest> {
        /**
         * <p>
         * The meaning of this parameter differs according to the database engine you use.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
         * database is created in the DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
         * database is created in the DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, a
         * database named <code>postgres</code> is created in the DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 63 letters, numbers, or underscores.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value
         * <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for
         * <code>DBName</code>.
         * </p>
         * <p>
         * Default: <code>ORCL</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be longer than 8 characters
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>SQL Server</b>
         * </p>
         * <p>
         * Not applicable. Must be null.
         * </p>
         * <p>
         * <b>Amazon Aurora MySQL</b>
         * </p>
         * <p>
         * The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If
         * this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must contain 1 to 64 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * It can't be a word reserved by the database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Amazon Aurora PostgreSQL</b>
         * </p>
         * <p>
         * The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
         * created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named
         * <code>postgres</code> is created in the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must contain 1 to 63 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0
         * to 9).
         * </p>
         * </li>
         * <li>
         * <p>
         * It can't be a word reserved by the database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbName
         *        The meaning of this parameter differs according to the database engine you use.</p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        no database is created in the DB instance.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        no database is created in the DB instance.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        a database named <code>postgres</code> is created in the DB instance.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 63 letters, numbers, or underscores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default
         *        value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for
         *        <code>DBName</code>.
         *        </p>
         *        <p>
         *        Default: <code>ORCL</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be longer than 8 characters
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>SQL Server</b>
         *        </p>
         *        <p>
         *        Not applicable. Must be null.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora MySQL</b>
         *        </p>
         *        <p>
         *        The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
         *        created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in
         *        the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must contain 1 to 64 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can't be a word reserved by the database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Amazon Aurora PostgreSQL</b>
         *        </p>
         *        <p>
         *        The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
         *        created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named
         *        <code>postgres</code> is created in the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must contain 1 to 63 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or
         *        digits (0 to 9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can't be a word reserved by the database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The DB instance identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The amount of storage (in gibibytes) to allocate for the DB instance.
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases,
         * though you are only charged for the space that you use in an Aurora cluster volume.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 10 to 3072.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>SQL Server</b>
         * </p>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 200 to 16384.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 20 to 16384.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 200 to 16384.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 100 to 16384.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 200 to 1024.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 20 to 1024.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gibibytes) to allocate for the DB instance.</p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database
         *        increases, though you are only charged for the space that you use in an Aurora cluster volume.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 10 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>SQL Server</b>
         *        </p>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 200 to 16384.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 20 to 16384.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 200 to 16384.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 100 to 16384.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 200 to 1024.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 20 to 1024.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
         * instance classes are available in all AWS Regions, or for all database engines. For the full list of DB
         * instance classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param dbInstanceClass
         *        The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
         *        instance classes are available in all AWS Regions, or for all database engines. For the full list of
         *        DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The name of the database engine to be used for this instance.
         * </p>
         * <p>
         * Not every database engine is available for every AWS Region.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mariadb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>postgres</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The name of the database engine to be used for this instance. </p>
         *        <p>
         *        Not every database engine is available for every AWS Region.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mariadb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>postgres</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The name for the master user.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The name for the master user is managed by the DB cluster.
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required for MariaDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 16 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required for SQL Server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 128 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required for MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 16 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required for Oracle.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 30 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required for PostgreSQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be 1 to 63 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name for the master user.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The name for the master user is managed by the DB cluster.
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required for MariaDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required for SQL Server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 128 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required for MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required for Oracle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 30 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required for PostgreSQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be 1 to 63 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master user. The password can include any printable ASCII character except "/",
         * """, or "@".
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The password for the master user is managed by the DB cluster.
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 30 characters.
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user. The password can include any printable ASCII character except "/",
         *        """, or "@".</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The password for the master user is managed by the DB cluster.
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 128 characters.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 30 characters.
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Constraints: Must contain from 8 to 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * Default: The default DB security group for the database engine.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        Default: The default DB security group for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * Default: The default DB security group for the database engine.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        Default: The default DB security group for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with this DB instance.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with this DB instance.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The Availability Zone (AZ) where the database will be created. For information on AWS Regions and
         * Availability Zones, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Regions and Availability Zones</a>.
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.
         * </p>
         * <p>
         * Example: <code>us-east-1d</code>
         * </p>
         * <p>
         * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
         * deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.
         * </p>
         * <note>
         * <p>
         * If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom
         * Availability Zone to create the DB instance in.
         * </p>
         * <p>
         * For more information about RDS on VMware, see the <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware
         * User Guide.</a>
         * </p>
         * </note>
         * 
         * @param availabilityZone
         *        The Availability Zone (AZ) where the database will be created. For information on AWS Regions and
         *        Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Regions and Availability Zones</a>. </p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.
         *        </p>
         *        <p>
         *        Example: <code>us-east-1d</code>
         *        </p>
         *        <p>
         *        Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a
         *        Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current
         *        endpoint.
         *        </p>
         *        <note>
         *        <p>
         *        If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom
         *        Availability Zone to create the DB instance in.
         *        </p>
         *        <p>
         *        For more information about RDS on VMware, see the <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on
         *        VMware User Guide.</a>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A DB subnet group to associate with this DB instance.
         * </p>
         * <p>
         * If there is no DB subnet group, then it is a non-VPC DB instance.
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group to associate with this DB instance.</p>
         *        <p>
         *        If there is no DB subnet group, then it is a non-VPC DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         * >Amazon RDS Maintenance Window</a>.
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week.
         * </p>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The time range each week during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC). For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         *        >Amazon RDS Maintenance Window</a>. </p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then
         * the default DB parameter group for the specified DB engine and version is used.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to associate with this DB instance. If you do not specify a value,
         *        then the default DB parameter group for the specified DB engine and version is used.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * The number of days for which automated backups are retained. Setting this parameter to a positive number
         * enables backups. Setting this parameter to 0 disables automated backups.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The retention period for automated backups is managed by the DB cluster.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 0 to 35
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be set to 0 if the DB instance is a source to read replicas
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. Setting this parameter to a positive
         *        number enables backups. Setting this parameter to 0 disables automated backups.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The retention period for automated backups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 0 to 35
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be set to 0 if the DB instance is a source to read replicas
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, using the
         * <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an
         * 8-hour block of time for each AWS Region. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         * >Backup window</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled,
         *        using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at
         *        random from an 8-hour block of time for each AWS Region. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         *        >Backup window</a> in the <i>Amazon RDS User Guide</i>. </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The port number on which the database accepts connections.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Default: <code>5432</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Default: <code>1521</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * <b>SQL Server</b>
         * </p>
         * <p>
         * Default: <code>1433</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
         * <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Default: <code>3306</code>
         * </p>
         * <p>
         * Valid values: <code>1150-65535</code>
         * </p>
         * <p>
         * Type: Integer
         * </p>
         * 
         * @param port
         *        The port number on which the database accepts connections.</p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Default: <code>5432</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Type: Integer
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Default: <code>1521</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        <b>SQL Server</b>
         *        </p>
         *        <p>
         *        Default: <code>1433</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>,
         *        <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Default: <code>3306</code>
         *        </p>
         *        <p>
         *        Valid values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Type: Integer
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         * </p>
         * 
         * @param multiAZ
         *        A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * <p>
         * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
         * </p>
         * <p>
         * The following are the database engines and links to information about the major and minor versions that are
         * available with Amazon RDS. Not every database engine is available for every AWS Region.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB
         * cluster.
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * See <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
         * >MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * See <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
         * >Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         * >MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle
         * Database Engine Release Notes</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon
         * RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.</p>
         *        <p>
         *        For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
         *        </p>
         *        <p>
         *        The following are the database engines and links to information about the major and minor versions
         *        that are available with Amazon RDS. Not every database engine is available for every AWS Region.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The version number of the database engine to be used by the DB instance is managed by
         *        the DB cluster.
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
         *        >MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
         *        >Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         *        >MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        See <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html"
         *        >Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
         *        >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the
         * maintenance window. By default, minor engine upgrades are applied automatically.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        A value that indicates whether minor engine upgrades are applied automatically to the DB instance
         *        during the maintenance window. By default, minor engine upgrades are applied automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * License model information for this DB instance.
         * </p>
         * <p>
         * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         * <code>general-public-license</code>
         * </p>
         * 
         * @param licenseModel
         *        License model information for this DB instance.</p>
         *        <p>
         *        Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         *        <code>general-public-license</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
         * instance. For information about valid Iops values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         * Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of
         * the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of
         * the storage amount for the DB instance.
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the
         *        DB instance. For information about valid Iops values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         *        Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>. </p>
         *        <p>
         *        Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5
         *        and 50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple
         *        between 1 and 50 of the storage amount for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * A value that indicates that the DB instance should be associated with the specified option group.
         * </p>
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
         * group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance
         * </p>
         * 
         * @param optionGroupName
         *        A value that indicates that the DB instance should be associated with the specified option group.</p>
         *        <p>
         *        Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
         *        option group. Also, that option group can't be removed from a DB instance once it is associated with a
         *        DB instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * For supported engines, indicates that the DB instance should be associated with the specified CharacterSet.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The character set is managed by the DB cluster. For more information, see
         * <code>CreateDBCluster</code>.
         * </p>
         * 
         * @param characterSetName
         *        For supported engines, indicates that the DB instance should be associated with the specified
         *        CharacterSet.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The character set is managed by the DB cluster. For more information, see
         *        <code>CreateDBCluster</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The name of the NCHAR character set for the Oracle DB instance.
         * </p>
         * 
         * @param ncharCharacterSetName
         *        The name of the NCHAR character set for the Oracle DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ncharCharacterSetName(String ncharCharacterSetName);

        /**
         * <p>
         * A value that indicates whether the DB instance is publicly accessible.
         * </p>
         * <p>
         * When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within
         * the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB
         * instance is ultimately controlled by the security group it uses, and that public access is not permitted if
         * the security group assigned to the DB instance doesn't permit it.
         * </p>
         * <p>
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves
         * to a private IP address.
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.
         * </p>
         * </li>
         * </ul>
         * 
         * @param publiclyAccessible
         *        A value that indicates whether the DB instance is publicly accessible.</p>
         *        <p>
         *        When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from
         *        within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC.
         *        Access to the DB instance is ultimately controlled by the security group it uses, and that public
         *        access is not permitted if the security group assigned to the DB instance doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB
         *        instance is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target region has an Internet gateway attached to it, the DB instance is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance
         *        is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is
         *        public.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The identifier of the DB cluster that the instance will belong to.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The identifier of the DB cluster that the instance will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Specifies the storage type to be associated with the DB instance.
         * </p>
         * <p>
         * Valid values: <code>standard | gp2 | io1</code>
         * </p>
         * <p>
         * If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.
         * </p>
         * <p>
         * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the DB instance.</p>
         *        <p>
         *        Valid values: <code>standard | gp2 | io1</code>
         *        </p>
         *        <p>
         *        If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.
         *        </p>
         *        <p>
         *        Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which to associate the instance for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * The password for the given ARN from the key store in order to access the device.
         * </p>
         * 
         * @param tdeCredentialPassword
         *        The password for the given ARN from the key store in order to access the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialPassword(String tdeCredentialPassword);

        /**
         * <p>
         * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The encryption for DB instances is managed by the DB cluster.
         * </p>
         * 
         * @param storageEncrypted
         *        A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The encryption for DB instances is managed by the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The AWS KMS key identifier for an encrypted DB instance.
         * </p>
         * <p>
         * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master
         * key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. The AWS KMS key identifier is managed by the DB cluster. For more information, see
         * <code>CreateDBCluster</code>.
         * </p>
         * <p>
         * If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
         * parameter, then Amazon RDS uses your default CMK. There is a default CMK for your AWS account. Your AWS
         * account has a different default CMK for each AWS Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key identifier for an encrypted DB instance.</p>
         *        <p>
         *        The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
         *        master key (CMK). To use a CMK in a different AWS account, specify the key ARN or alias ARN.
         *        </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. The AWS KMS key identifier is managed by the DB cluster. For more information, see
         *        <code>CreateDBCluster</code>.
         *        </p>
         *        <p>
         *        If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the
         *        <code>KmsKeyId</code> parameter, then Amazon RDS uses your default CMK. There is a default CMK for
         *        your AWS account. Your AWS account has a different default CMK for each AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server,
         * Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         * Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
         *        Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         *        Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default,
         * tags are not copied.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB
         * instance has no effect on the DB cluster setting.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By
         *        default, tags are not copied.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an
         *        Aurora DB instance has no effect on the DB cluster setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a
         * value other than 0.
         * </p>
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code>
         *        to a value other than 0.
         *        </p>
         *        <p>
         *        Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
         * go to <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
         *        monitoring role, go to <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         *        >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         *        <code>MonitoringRoleArn</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * 
         * @param domainIAMRoleName
         *        Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a
         * failure of the existing primary instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
         * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Valid Values: 0 - 15
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which an Aurora Replica is promoted to the primary instance after
         *        a failure of the existing primary instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"
         *        > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Valid Values: 0 - 15
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The time zone of the DB instance. The time zone parameter is currently supported only by <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
         * >Microsoft SQL Server</a>.
         * </p>
         * 
         * @param timezone
         *        The time zone of the DB instance. The time zone parameter is currently supported only by <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
         *        >Microsoft SQL Server</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping is disabled.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora. Mapping AWS IAM accounts to database accounts is managed by the
         * DB cluster.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts
         *        to database accounts. By default, mapping is disabled.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora. Mapping AWS IAM accounts to database accounts is managed
         *        by the DB cluster.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * A value that indicates whether to enable Performance Insights for the DB instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
         * Insights</a> in the <i>Amazon Relational Database Service User Guide</i>.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        A value that indicates whether to enable Performance Insights for the DB instance. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
         *        Performance Insights</a> in the <i>Amazon Relational Database Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The AWS KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer master
         * key (CMK).
         * </p>
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * CMK. There is a default CMK for your AWS account. Your AWS account has a different default CMK for each AWS
         * Region.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The AWS KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the AWS KMS customer
         *        master key (CMK).
         *        </p>
         *        <p>
         *        If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default CMK. There is a default CMK for your AWS account. Your AWS account has a different default CMK
         *        for each AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service User
         * Guide</i>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * Possible values are <code>agent</code> and <code>error</code>.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and
         * <code>oemagent</code>.
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service
         *        User Guide</i>.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        Possible values are <code>agent</code> and <code>error</code>.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>,
         *        and <code>oemagent</code>.
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend
         * on the DB engine being used. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service User
         * Guide</i>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         * </p>
         * <p>
         * <b>MariaDB</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * Possible values are <code>agent</code> and <code>error</code>.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and
         * <code>oemagent</code>.
         * </p>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list
         *        depend on the DB engine being used. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon Relational Database Service
         *        User Guide</i>.</p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         *        </p>
         *        <p>
         *        <b>MariaDB</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        Possible values are <code>agent</code> and <code>error</code>.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and
         *        <code>slowquery</code>.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>,
         *        and <code>oemagent</code>.
         *        </p>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        Possible values are <code>postgresql</code> and <code>upgrade</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<ProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(ProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessorFeature>.Builder} avoiding the
         * need to create one manually via {@link List<ProcessorFeature>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessorFeature>.Builder#build()} is called immediately and
         * its result is passed to {@link #processorFeatures(List<ProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on {@link List<ProcessorFeature>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(List<ProcessorFeature>)
         */
        Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection is disabled. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         * Instance</a>.
         * </p>
         * <p>
         * <b>Amazon Aurora</b>
         * </p>
         * <p>
         * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see
         * <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is
         * enabled for the DB cluster.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB instance has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection is disabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         *        Instance</a>. </p>
         *        <p>
         *        <b>Amazon Aurora</b>
         *        </p>
         *        <p>
         *        Not applicable. You can enable or disable deletion protection for the DB cluster. For more
         *        information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when
         *        deletion protection is enabled for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
         * </p>
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p>
         *        <p>
         *        For more information about this setting, including limitations that apply to it, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
         *        > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
         * instance.
         * </p>
         * <p>
         * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
         * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance
         * from outside of its virtual private cloud (VPC) on your local network.
         * </p>
         * <p>
         * For more information about RDS on Outposts, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
         * AWS Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about CoIPs, see <a href=
         * "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
         * >Customer-owned IP addresses</a> in the <i>AWS Outposts User Guide</i>.
         * </p>
         * 
         * @param enableCustomerOwnedIp
         *        A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB
         *        instance.</p>
         *        <p>
         *        A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through
         *        your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the
         *        DB instance from outside of its virtual private cloud (VPC) on your local network.
         *        </p>
         *        <p>
         *        For more information about RDS on Outposts, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
         *        RDS on AWS Outposts</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about CoIPs, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing"
         *        >Customer-owned IP addresses</a> in the <i>AWS Outposts User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbName;

        private String dbInstanceIdentifier;

        private Integer allocatedStorage;

        private String dbInstanceClass;

        private String engine;

        private String masterUsername;

        private String masterUserPassword;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String dbSubnetGroupName;

        private String preferredMaintenanceWindow;

        private String dbParameterGroupName;

        private Integer backupRetentionPeriod;

        private String preferredBackupWindow;

        private Integer port;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String characterSetName;

        private String ncharCharacterSetName;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private String storageType;

        private String tdeCredentialArn;

        private String tdeCredentialPassword;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String domain;

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private String domainIAMRoleName;

        private Integer promotionTier;

        private String timezone;

        private Boolean enableIAMDatabaseAuthentication;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private Integer maxAllocatedStorage;

        private Boolean enableCustomerOwnedIp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceRequest model) {
            super(model);
            dbName(model.dbName);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            allocatedStorage(model.allocatedStorage);
            dbInstanceClass(model.dbInstanceClass);
            engine(model.engine);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            availabilityZone(model.availabilityZone);
            dbSubnetGroupName(model.dbSubnetGroupName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            dbParameterGroupName(model.dbParameterGroupName);
            backupRetentionPeriod(model.backupRetentionPeriod);
            preferredBackupWindow(model.preferredBackupWindow);
            port(model.port);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            characterSetName(model.characterSetName);
            ncharCharacterSetName(model.ncharCharacterSetName);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
            dbClusterIdentifier(model.dbClusterIdentifier);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            tdeCredentialPassword(model.tdeCredentialPassword);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            domain(model.domain);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            domainIAMRoleName(model.domainIAMRoleName);
            promotionTier(model.promotionTier);
            timezone(model.timezone);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            processorFeatures(model.processorFeatures);
            deletionProtection(model.deletionProtection);
            maxAllocatedStorage(model.maxAllocatedStorage);
            enableCustomerOwnedIp(model.enableCustomerOwnedIp);
        }

        public final String getDbName() {
            return dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getNcharCharacterSetName() {
            return ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final String getTdeCredentialPassword() {
            return tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> ProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceRequest build() {
            return new CreateDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
