/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data returned by the <b>DescribeAccountAttributes</b> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAttributesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<List<AccountQuota>> ACCOUNT_QUOTAS_FIELD = SdkField
            .<List<AccountQuota>> builder(MarshallingType.LIST)
            .memberName("AccountQuotas")
            .getter(getter(DescribeAccountAttributesResponse::accountQuotas))
            .setter(setter(Builder::accountQuotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountQuotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccountQuota")
                            .memberFieldInfo(
                                    SdkField.<AccountQuota> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountQuota::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccountQuota").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_QUOTAS_FIELD));

    private final List<AccountQuota> accountQuotas;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountQuotas = builder.accountQuotas;
    }

    /**
     * Returns true if the AccountQuotas property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccountQuotas() {
        return accountQuotas != null && !(accountQuotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward the
     * quota maximum, and a maximum value for the quota.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountQuotas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage
     *         toward the quota maximum, and a maximum value for the quota.
     */
    public final List<AccountQuota> accountQuotas() {
        return accountQuotas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountQuotas() ? accountQuotas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        return hasAccountQuotas() == other.hasAccountQuotas() && Objects.equals(accountQuotas(), other.accountQuotas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAttributesResponse")
                .add("AccountQuotas", hasAccountQuotas() ? accountQuotas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountQuotas":
            return Optional.ofNullable(clazz.cast(accountQuotas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward
         * the quota maximum, and a maximum value for the quota.
         * </p>
         * 
         * @param accountQuotas
         *        A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage
         *        toward the quota maximum, and a maximum value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotas(Collection<AccountQuota> accountQuotas);

        /**
         * <p>
         * A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward
         * the quota maximum, and a maximum value for the quota.
         * </p>
         * 
         * @param accountQuotas
         *        A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage
         *        toward the quota maximum, and a maximum value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotas(AccountQuota... accountQuotas);

        /**
         * <p>
         * A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward
         * the quota maximum, and a maximum value for the quota.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountQuota>.Builder} avoiding the need to
         * create one manually via {@link List<AccountQuota>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountQuota>.Builder#build()} is called immediately and its
         * result is passed to {@link #accountQuotas(List<AccountQuota>)}.
         * 
         * @param accountQuotas
         *        a consumer that will call methods on {@link List<AccountQuota>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountQuotas(List<AccountQuota>)
         */
        Builder accountQuotas(Consumer<AccountQuota.Builder>... accountQuotas);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<AccountQuota> accountQuotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            accountQuotas(model.accountQuotas);
        }

        public final List<AccountQuota.Builder> getAccountQuotas() {
            List<AccountQuota.Builder> result = AccountQuotaListCopier.copyToBuilder(this.accountQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accountQuotas(Collection<AccountQuota> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copy(accountQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(AccountQuota... accountQuotas) {
            accountQuotas(Arrays.asList(accountQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(Consumer<AccountQuota.Builder>... accountQuotas) {
            accountQuotas(Stream.of(accountQuotas).map(c -> AccountQuota.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountQuotas(Collection<AccountQuota.BuilderImpl> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copyFromBuilder(accountQuotas);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
