/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbProxyTargetsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbProxyTargetsResponse.Builder, DescribeDbProxyTargetsResponse> {
    private static final SdkField<List<DBProxyTarget>> TARGETS_FIELD = SdkField
            .<List<DBProxyTarget>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(DescribeDbProxyTargetsResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DBProxyTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBProxyTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbProxyTargetsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD, MARKER_FIELD));

    private final List<DBProxyTarget> targets;

    private final String marker;

    private DescribeDbProxyTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding
     *         targets.
     */
    public final List<DBProxyTarget> targets() {
        return targets;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxyTargetsResponse)) {
            return false;
        }
        DescribeDbProxyTargetsResponse other = (DescribeDbProxyTargetsResponse) obj;
        return hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbProxyTargetsResponse").add("Targets", hasTargets() ? targets() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxyTargetsResponse, T> g) {
        return obj -> g.apply((DescribeDbProxyTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbProxyTargetsResponse> {
        /**
         * <p>
         * An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.
         * </p>
         * 
         * @param targets
         *        An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<DBProxyTarget> targets);

        /**
         * <p>
         * An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.
         * </p>
         * 
         * @param targets
         *        An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(DBProxyTarget... targets);

        /**
         * <p>
         * An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBProxyTarget>.Builder} avoiding the need
         * to create one manually via {@link List<DBProxyTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBProxyTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #targets(List<DBProxyTarget>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<DBProxyTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<DBProxyTarget>)
         */
        Builder targets(Consumer<DBProxyTarget.Builder>... targets);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<DBProxyTarget> targets = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxyTargetsResponse model) {
            super(model);
            targets(model.targets);
            marker(model.marker);
        }

        public final List<DBProxyTarget.Builder> getTargets() {
            List<DBProxyTarget.Builder> result = TargetListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Collection<DBProxyTarget> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(DBProxyTarget... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<DBProxyTarget.Builder>... targets) {
            targets(Stream.of(targets).map(c -> DBProxyTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<DBProxyTarget.BuilderImpl> targets) {
            this.targets = TargetListCopier.copyFromBuilder(targets);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDbProxyTargetsResponse build() {
            return new DescribeDbProxyTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
