/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbProxyEndpointResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyDbProxyEndpointResponse.Builder, ModifyDbProxyEndpointResponse> {
    private static final SdkField<DBProxyEndpoint> DB_PROXY_ENDPOINT_FIELD = SdkField
            .<DBProxyEndpoint> builder(MarshallingType.SDK_POJO).memberName("DBProxyEndpoint")
            .getter(getter(ModifyDbProxyEndpointResponse::dbProxyEndpoint)).setter(setter(Builder::dbProxyEndpoint))
            .constructor(DBProxyEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINT_FIELD));

    private final DBProxyEndpoint dbProxyEndpoint;

    private ModifyDbProxyEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxyEndpoint = builder.dbProxyEndpoint;
    }

    /**
     * <p>
     * The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.
     * </p>
     * 
     * @return The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.
     */
    public final DBProxyEndpoint dbProxyEndpoint() {
        return dbProxyEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyEndpointResponse)) {
            return false;
        }
        ModifyDbProxyEndpointResponse other = (ModifyDbProxyEndpointResponse) obj;
        return Objects.equals(dbProxyEndpoint(), other.dbProxyEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbProxyEndpointResponse").add("DBProxyEndpoint", dbProxyEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyEndpoint":
            return Optional.ofNullable(clazz.cast(dbProxyEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyEndpointResponse, T> g) {
        return obj -> g.apply((ModifyDbProxyEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbProxyEndpointResponse> {
        /**
         * <p>
         * The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.
         * </p>
         * 
         * @param dbProxyEndpoint
         *        The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyEndpoint(DBProxyEndpoint dbProxyEndpoint);

        /**
         * <p>
         * The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link DBProxyEndpoint.Builder} avoiding the need to
         * create one manually via {@link DBProxyEndpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBProxyEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #dbProxyEndpoint(DBProxyEndpoint)}.
         * 
         * @param dbProxyEndpoint
         *        a consumer that will call methods on {@link DBProxyEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbProxyEndpoint(DBProxyEndpoint)
         */
        default Builder dbProxyEndpoint(Consumer<DBProxyEndpoint.Builder> dbProxyEndpoint) {
            return dbProxyEndpoint(DBProxyEndpoint.builder().applyMutation(dbProxyEndpoint).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBProxyEndpoint dbProxyEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyEndpointResponse model) {
            super(model);
            dbProxyEndpoint(model.dbProxyEndpoint);
        }

        public final DBProxyEndpoint.Builder getDbProxyEndpoint() {
            return dbProxyEndpoint != null ? dbProxyEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder dbProxyEndpoint(DBProxyEndpoint dbProxyEndpoint) {
            this.dbProxyEndpoint = dbProxyEndpoint;
            return this;
        }

        public final void setDbProxyEndpoint(DBProxyEndpoint.BuilderImpl dbProxyEndpoint) {
            this.dbProxyEndpoint = dbProxyEndpoint != null ? dbProxyEndpoint.build() : null;
        }

        @Override
        public ModifyDbProxyEndpointResponse build() {
            return new ModifyDbProxyEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
