/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCertificatesRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyCertificatesRequest> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateIdentifier").getter(ModifyCertificatesRequest.getter(ModifyCertificatesRequest::certificateIdentifier)).setter(ModifyCertificatesRequest.setter(Builder::certificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build()}).build();
    private static final SdkField<Boolean> REMOVE_CUSTOMER_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveCustomerOverride").getter(ModifyCertificatesRequest.getter(ModifyCertificatesRequest::removeCustomerOverride)).setter(ModifyCertificatesRequest.setter(Builder::removeCustomerOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveCustomerOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD, REMOVE_CUSTOMER_OVERRIDE_FIELD));
    private final String certificateIdentifier;
    private final Boolean removeCustomerOverride;

    private ModifyCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateIdentifier = builder.certificateIdentifier;
        this.removeCustomerOverride = builder.removeCustomerOverride;
    }

    public final String certificateIdentifier() {
        return this.certificateIdentifier;
    }

    public final Boolean removeCustomerOverride() {
        return this.removeCustomerOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeCustomerOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCertificatesRequest)) {
            return false;
        }
        ModifyCertificatesRequest other = (ModifyCertificatesRequest)((Object)obj);
        return Objects.equals(this.certificateIdentifier(), other.certificateIdentifier()) && Objects.equals(this.removeCustomerOverride(), other.removeCustomerOverride());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCertificatesRequest").add("CertificateIdentifier", (Object)this.certificateIdentifier()).add("RemoveCustomerOverride", (Object)this.removeCustomerOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateIdentifier()));
            }
            case "RemoveCustomerOverride": {
                return Optional.ofNullable(clazz.cast(this.removeCustomerOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCertificatesRequest, T> g) {
        return obj -> g.apply((ModifyCertificatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String certificateIdentifier;
        private Boolean removeCustomerOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCertificatesRequest model) {
            super(model);
            this.certificateIdentifier(model.certificateIdentifier);
            this.removeCustomerOverride(model.removeCustomerOverride);
        }

        public final String getCertificateIdentifier() {
            return this.certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final Boolean getRemoveCustomerOverride() {
            return this.removeCustomerOverride;
        }

        @Override
        public final Builder removeCustomerOverride(Boolean removeCustomerOverride) {
            this.removeCustomerOverride = removeCustomerOverride;
            return this;
        }

        public final void setRemoveCustomerOverride(Boolean removeCustomerOverride) {
            this.removeCustomerOverride = removeCustomerOverride;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCertificatesRequest build() {
            return new ModifyCertificatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCertificatesRequest> {
        public Builder certificateIdentifier(String var1);

        public Builder removeCustomerOverride(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

