/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;

public class DescribeDBSnapshotsIterable
implements SdkIterable<DescribeDbSnapshotsResponse> {
    private final RdsClient client;
    private final DescribeDbSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSnapshotsIterable(RdsClient client, DescribeDbSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbSnapshotsResponseFetcher();
    }

    public Iterator<DescribeDbSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBSnapshot> dbSnapshots() {
        Function<DescribeDbSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshots() != null) {
                return response.dbSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeDbSnapshotsResponse> {
        private DescribeDbSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbSnapshotsResponse nextPage(DescribeDbSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotsIterable.this.client.describeDBSnapshots(DescribeDBSnapshotsIterable.this.firstRequest);
            }
            return DescribeDBSnapshotsIterable.this.client.describeDBSnapshots((DescribeDbSnapshotsRequest)((Object)DescribeDBSnapshotsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

